package cn.com.servyou.dto.tax;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 综合所得
 *
 * @author zhouww
 * @version 20191016
 */
@Data
public class ComplexIncome extends BaseEmp {

    private static final long serialVersionUID = -540023009353656981L;

    private Integer id;

    /**
     * 批次号(一月多次发薪)
     */
    @JsonProperty("pch")
    private Integer batchNo;

    /**
     * 是否明细申报
     */
    @JsonProperty("sfmxsb")
    private String isDetailedDeclaration;

    /**
     * 是否自动生成附表
     * 只对解除劳动合同一次性补偿金和稿酬所得生效
     */
    @JsonProperty("sfzdscmsfb")
    private String isAutoGenerateExempt;

    /**
     * 所属期
     */
    @JsonProperty("skssq")
    private String period;

    /**
     * 收入额-工资薪金，年终奖金，解除，劳务报酬，稿酬所得
     */
    @JsonProperty("sre")
    private BigDecimal income;

    /**
     * 已完税缴费额
     */
    @JsonProperty("ywsjfe")
    private BigDecimal taxedPayCost;

    /**
     * 全部缴费额
     */
    @JsonProperty("qbjfe")
    private BigDecimal allPayCost;

    /**
     * 分摊月份数
     */
    @JsonProperty("ftyfs")
    private Integer apportionMonths;

    /**
     * 是否一次性领取
     * 1-是，0-否
     */
    @JsonProperty("sfycxlq")
    private String onceReceipt;

    /**
     * 年金领取方式
     */
    @JsonProperty("njlqfs")
    private String annuityReceiptTypeName;

    /**
     * 年金领取原因
     */
    @JsonProperty("njlqyy")
    private String annuityReceiptReasonName;

    /**
     * 免税收入-工资薪金，年终奖金，解除，劳务报酬，稿酬所得
     */
    @JsonProperty("mssd")
    private BigDecimal exemptIncome;

    /**
     * 基本养老保险
     */
    @JsonProperty("jbylaobxf")
    private BigDecimal endowmentInsurance;

    /**
     * 基本医疗保险
     */
    @JsonProperty("jbylbxf")
    private BigDecimal medicalInsurance;

    /**
     * 失业保险
     */
    @JsonProperty("sybxf")
    private BigDecimal unemploymentInsurance;

    /**
     * 住房公积金
     */
    @JsonProperty("zfgjj")
    private BigDecimal houseProvidentFund;

    /**
     * 原始住房公积金 保存用户的传入的住房公积金
     * houseProvidentFund这个字段在某些场景下会改变，所以使用originalHouseProvidentFund这个字段保存原来的公积金
     */
    @JsonProperty("yszfgjj")
    private BigDecimal originalHouseProvidentFund;

    /**
     * 子女教育支出
     */
    @JsonProperty("znjyzc")
    private BigDecimal childEducationExpenditure;

    /**
     * 赡养老人支出
     */
    @JsonProperty("sylrzc")
    private BigDecimal supportElderExpenditure;

    /**
     * 住房租金支出
     */
    @JsonProperty("zfzjzc")
    private BigDecimal houseRentExpenditure;

    /**
     * 房屋贷款支出
     */
    @JsonProperty("zfdklxzc")
    private BigDecimal houseLoanExpenditure;

    /**
     * 继续教育支出
     */
    @JsonProperty("jxjyzc")
    private BigDecimal continueEducationExpenditure;

    /**
     * 大病医疗支出
     */
    @JsonProperty("dbylzc")
    private BigDecimal seriousIllnessExpenditure;

    /**
     * 婴幼儿照护支出
     */
    @JsonProperty("yyezhzc")
    private BigDecimal babyCareExpenditure;

    /**
     * 企业年金/职业年金
     */
    @JsonProperty("nj")
    private BigDecimal annuity;

    /**
     * 原始年金 保存用户传入的年金
     * annuity这个字段在某项场景下会改变 需要存储下原始的annuity
     */
    @JsonProperty("ysnj")
    private BigDecimal originalAnnuity;

    /**
     * 商业健康保险
     */
    @JsonProperty("syjkbx")
    private BigDecimal commercialHealthInsurance;

    /**
     * 税延养老保险
     */
    @JsonProperty("syylbx")
    private BigDecimal extensionEndowmentInsurance;

    /**
     * 其他
     */
    @JsonProperty("qt")
    private BigDecimal other;

    /**
     * 准予扣除的捐赠额
     */
    @JsonProperty("zykcjze")
    private BigDecimal deductibleDonation;

    /**
     * 累计个人养老金
     */
    @JsonProperty("ljgrylj")
    private BigDecimal accumulatedPersonalPension;

    /**
     * 累计个人养老金校验码
     */
    @JsonProperty("ljgryljjym")
    private String accumulatedPersonalPensionCheckCode;

    /**
     * 减免税额
     */
    @JsonProperty("jmse")
    private BigDecimal taxDeduction;

    /**
     * 备注
     */
    @JsonProperty("bz")
    private String remark;

    /**
     * 专项扣除合计
     * 本期专项扣除合计=基本养老保险费+基本医疗保险费+失业保险费+住房公积金
     */
    @JsonProperty("zxkchj")
    private BigDecimal specDeductionSum;

    /**
     * 专项附加扣除合计
     * 本期专项扣除合计=子女教育支出+大病医疗支出+继续教育支出+住房贷款利息支出+住房租金支出+赡养老人支出
     */
    @JsonProperty("zxfjkchj")
    private BigDecimal specAttachDeductionSum;

    /**
     * 减除费用
     */
    @JsonProperty("jcfy")
    private BigDecimal deductionAmount;

    /**
     * 其他扣除合计
     */
    @JsonProperty("qtckhj")
    private BigDecimal otherDeductionSum;

    /**
     * 应纳税所得额
     */
    @JsonProperty("ynssde")
    private BigDecimal taxableIncome;

    /**
     * 应纳税额
     */
    @JsonProperty("ynse")
    private BigDecimal payableAmount;

    /**
     * 已缴税额
     *
     * 财政统发已缴税额只有财政单位才可以填写；界面不支持录入和展示，如果其他界面或者报文要用到默认传0.00
     */
    @JsonProperty("ykjse")
    private BigDecimal paidAmount;

    /**
     * 应扣缴税额
     */
    @JsonProperty("yingkjse")
    private BigDecimal withholdingAmount;

    /**
     * 税率
     */
    @JsonProperty("sl")
    private BigDecimal taxRate;

    /**
     * 速算扣除数
     */
    @JsonProperty("sskcs")
    private BigDecimal quickDeduction;

    /**
     * 所得项目代码
     */
    @JsonProperty("sdxmda")
    private String incomeItemCode;

    /**
     * 所得项目名称-正常工资薪金，全年一次性奖金，解除劳动一次性补偿金，劳务报酬，稿酬所得
     */
    @JsonProperty("sdxm")
    private String incomeItemName;

    /**
     * 应补退税额=累计应扣缴税额-累计已缴税额
     */
    @JsonProperty("ybtse")
    private BigDecimal refundTax;

    /**
     * 累计收入额
     *
     * 本年累计收入=本期所有的工资薪金所得收入之和+往期工资薪金所得收入之和（见税款计算）
     */
    @JsonProperty("ljsre")
    private BigDecimal accumulatedIncome;

    /**
     * 累计免税收入额
     */
    @JsonProperty("ljmssd")
    private BigDecimal accumulatedExemptIncome;

    /**
     * 累计专项扣除额
     */
    @JsonProperty("ljzxkce")
    private BigDecimal accumulatedSpecDeduction;

    /**
     * 累计专项附加扣除额
     */
    @JsonProperty("ljzxfjkce")
    private BigDecimal accumulatedSpecAttachDeduction;

    /**
     * 累计其他扣除额
     */
    @JsonProperty("ljqtkce")
    private BigDecimal accumulatedOtherDeduction;

    /**
     * 累计减免税额
     */
    @JsonProperty("ljjmse")
    private BigDecimal accumulatedTaxDeduction;

    /**
     * 累计减除费用额
     */
    @JsonProperty("ljjcfye")
    private BigDecimal accumulatedDeductionAmount;

    /**
     * 累计月减除费用
     */
    @JsonProperty("ljyjcfy")
    private BigDecimal accumulatedMonthDeduction;

    /**
     * 累计应纳税所得额
     */
    @JsonProperty("ljynssde")
    private BigDecimal accumulatedTaxableIncome;

    /**
     * 累计应纳税额
     */
    @JsonProperty("ljynse")
    private BigDecimal accumulatedPayableAmount;

    /**
     * 累计应扣缴税额 = 累计应纳税额 - 累计减免税额
     */
    @JsonProperty("ljyingkjse")
    private BigDecimal accumulatedWithholdingAmount;

    /**
     * 累计子女教育支出
     */
    @JsonProperty("ljznjyzc")
    private BigDecimal accumulatedChildEducation;

    /**
     * 累计大病医疗支出
     */
    @JsonProperty("ljdbylzc")
    private BigDecimal accumulatedSeriousIllness;

    /**
     * 累计继续教育支出
     */
    @JsonProperty("ljjxjyzc")
    private BigDecimal accumulatedContinueEducation;

    /**
     * 累计学历继续教育支出
     */
    @JsonProperty("ljxljxjyzc")
    private BigDecimal accumulatedDegreeContinueEducationLimit;

    /**
     * 累计非学历继续教育支出
     */
    @JsonProperty("ljfxljxjyzc")
    private BigDecimal accumulatedUnDegreeContinueEducationLimit;

    /**
     * 学历继续教育支出
     */
    @JsonProperty("xljxjyzc")
    private BigDecimal degreeContinueEducationExpenditure;

    /**
     * 非学历继续教育支出
     */
    @JsonProperty("fxljxjyzc")
    private BigDecimal unDegreeContinueEducationExpenditure;

    /**
     * 累计住房租金支出
     */
    @JsonProperty("ljzfzjzc")
    private BigDecimal accumulatedHouseRent;

    /**
     * 累计房屋贷款支出
     */
    @JsonProperty("ljzfdklxzc")
    private BigDecimal accumulatedHouseLoan;

    /**
     * 累计赡养老人支出
     */
    @JsonProperty("ljsylrzc")
    private BigDecimal accumulatedSupportElder;

    /**
     * 累计婴幼儿照护支出
     */
    @JsonProperty("ljyyezhzc")
    private BigDecimal accumulatedBabyCare;

    /**
     * 累计准予扣除的捐赠额
     */
    @JsonProperty("ljzykcjze")
    private BigDecimal accumulatedDeductibleDonation;

    /**
     * 实际捐赠额
     */
    @JsonProperty("sjjze")
    private BigDecimal actualDonation;

    /**
     * 月工资薪金所得与法定减除费用额差额
     */
    @JsonProperty("ygzxjsdyxfdjcfyece")
    private BigDecimal salaryDeductionBalance;

    /**
     * 累计已缴税额
     */
    @JsonProperty("ljykjse")
    private BigDecimal accumulatedPaidAmount;

    /**
     * 往期数据类型，正常数据0，往期数据1
     */
    @JsonProperty("wqsjlx")
    private String pastDataType = "0";

    /**
     * 所属期开始
     */
    @JsonProperty("skssqks")
    private String incomePeriodStart;

    /**
     * 所属期结束
     */
    @JsonProperty("skssqjs")
    private String incomePeriodEnd;

    /**
     * 更正标志
     * 默认正常申报0, 更正1
     */
    @JsonProperty("gzbz")
    private String backupType;

    /**
     * 新增节点1: 企业上月是否已申报
     *
     * 节点判断规则：传当月的月份去下载往期数据，若成功下载到N-1月的数据，代表上月已申报；
     * 传当月的月份去下载往期数据，若下载不到数据，代表上月未申报
     *
     * 新增节点2：员工在税局累计已扣缴的税额
     *
     * 节点判断规则：传当月的月份去下载往期数据，若成功下载到N-1月的数据，就将下载下来的税局累计已扣缴的税额返回；
     * 若下载不到数据，就将月份-1后再去下载数据
     *
     */

    /**
     * 企业上月是否已申报:
     *
     * 0表示未申报
     *
     * 1表示申报
     */
    @JsonProperty("qysysfysb")
    private String etaxDeclaredLastMonth;

    /**
     * 员工在税局累计已扣缴的税额
     */
    @JsonProperty("ygzsjljykjse")
    private BigDecimal etaxAccumulatedPaidAmount;

    /**
     * 本月已累计扣除税额
     */
    @JsonProperty("byyljkjse")
    private BigDecimal monthAccumulatedWithholdingAmount;

    /**
     * 本次应扣缴税额
     */
    @JsonProperty("bcykjse")
    private BigDecimal currentWithholdingAmount;

    /**
     * 试用公式
     */
    @JsonProperty("sygs")
    private String formula;

    /**
     * 境内工作天数
     */
    @JsonProperty("jngzts")
    private BigDecimal domesticWorkingDays;

    /**
     * 境外工作天数
     */
    @JsonProperty("jwgzts")
    private BigDecimal abroadWorkingDays;

    /**
     * 境外支付
     */
    @JsonProperty("jwzf")
    private BigDecimal abroadIncome;

    /**
     * 境内支付
     */
    @JsonProperty("jnzf")
    private BigDecimal domesticIncome;

    /**
     * 专项数据来源统计
     */
    @JsonProperty("zxsjlytj")
    private SpecialDataSourceStatistics specialDataSourceStatistics;

    /**
     * 允许扣除的税费
     */
    @JsonProperty("yxkcsf")
    private BigDecimal taxDeductible;

    /**
     * 展业成本
     */
    @JsonProperty("zycb")
    private BigDecimal exhibitionCost;

    /**
     * 月减除费用
     */
    @JsonProperty("yjcfy")
    private BigDecimal monthDeduction;

    /**
     * 本期工资数
     */
    @JsonProperty("bqgzs")
    private BigDecimal currentSalary;

    /**
     * 税后收入额
     */
    @JsonProperty("shsre")
    private BigDecimal afterTaxIncome;

    /**
     * 分摊年度数
     */
    @JsonProperty("ftnds")
    private Integer apportionYears;

    /**
     * 年减除费用
     */
    @JsonProperty("njcfy")
    private BigDecimal yearDeduction;

    /**
     * 备案编号
     *
     * @Description 通过上市公司股权激励延期纳税备案信息查询接口获取，若获取到多条需选择其中一个编号传入,
     * 如果传入了 上市公司股权激励递延备案编号 则 备案时间也需要填写
     */
    @JsonProperty("gqjldybabh")
    private String recordNumber;

    /**
     * 备案时间
     *
     * @Description 通过上市公司股权激励延期纳税备案信息查询接口获取，若获取到多条需选择其中一个编号传入
     * 如果传入了 备案时间 则 上市公司股权激励递延备案编号 也需要填写
     * yyyy-MM-dd
     */
    @JsonProperty("basj")
    private String recordDate;
}
