package cn.com.servyou.dto.tax;

import cn.com.servyou.dto.tax.deduction.DeductibleDonation;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author zhouww
 * @version 20191016
 */
@Data
public class ComplexIncomeRequest extends BaseIncomeRequest {

    private static final long serialVersionUID = -2454671777069503287L;

    /**
     * 是否离线算薪
     */
    @JsonProperty("sflxsx")
    private String isOffLineCalculateTax;

    /**
     * 减免方式
     * 其他方式不用传入
     * "1":"比例减免方式"
     * "2":"限额减免方式"
     */
    @JsonProperty("jmfs")
    private String deductionMode;

    /**
     * 减免比例
     */
    @JsonProperty("jmbl")
    private BigDecimal ratio;

    /**
     * 减免限额
     */
    @JsonProperty("jmxe")
    private BigDecimal limitAmount;

    /**
     * 正常工资薪金对象
     */
    @JsonProperty("zcgzxj")
    private NormalSalarySpecIncome normalSalarySpecIncome;

    /**
     * 无权限正常工资薪金对象
     */
    @JsonProperty("wqxzcgzxj")
    private PureSalary pureSalary;

    /**
     * 全年一次性奖金收入列表
     */
    @JsonProperty("qnycxjjsslb")
    private List<ComplexIncome> annualOneTimeBonusIncome;

    /**
     * 稿酬所得列表
     */
    @JsonProperty("gcsdlb")
    private List<ComplexIncome> authorsRemunerationIncome;

    /**
     * 劳务报酬所得列表
     */
    @JsonProperty("lwbclb")
    private List<ComplexIncome> laborRemunerationIncome;

    /**
     * 法律援助劳务报酬所得列表
     */
    @JsonProperty("flyzlwbclb")
    private List<ComplexIncome> legalAidLaborRemunerationIncomeList;

    /**
     * 解除劳动合同一次性补偿金列表
     */
    @JsonProperty("jcldhtycxbcjlb")
    private List<ComplexIncome> compensateIncome;

    /**
     * 内退一次性补偿金列表
     */
    @JsonProperty("ntycxbcjlb")
    private List<ComplexIncome> retreatIncome;

    /**
     * 保险营销员劳务报酬
     */
    @JsonProperty("bxyxy")
    private InsuranceMarketingIncome insuranceMarketingIncome;

    /**
     * 证券经纪人所得
     */
    @JsonProperty("zqjjr")
    private SecuritiesBrokerIncome securitiesBrokerIncome;

    /**
     * 其他连续劳务报酬所得
     */
    @JsonProperty("qtlxlwbc")
    private OtherContinuationLaborIncome otherContinuationLaborIncome;

    /**
     * 特许权使用费
     */
    @JsonProperty("txq")
    private List<ComplexIncome> royaltyFeeList;

    /**
     * 个人股权激励
     */
    @JsonProperty("grgqjl")
    private List<ComplexIncome> stockIncentiveList;

    /**
     * 企业年金
     */
    @JsonProperty("qynj")
    private List<ComplexIncome> enterpriseAnnuityList;

    /**
     * 其他非连续劳务报酬
     */
    @JsonProperty("qtflxlwbc")
    private List<ComplexIncome> otherLaborList;

    /**
     * 商业健康险附表列表
     */
    @JsonProperty("syjkbxfblb")
    private List<Insurance> insuranceList;

    /**
     * 减免附表列表
     */
    @JsonProperty("jmfblb")
    private List<IncomeDeduction> incomeDeductionList;

    /**
     * 税延养老保险附表列表
     */
    @JsonProperty("syylbxfblb")
    private List<ExtensionEndowmentInsurance> extensionEndowmentInsuranceList;

    /**
     * 免税附表列表
     */
    @JsonProperty("msfblb")
    private List<ExemptIncome> exemptIncomeList;

    /**
     * 准予扣除的捐赠额附表
     */
    @JsonProperty("zykcjzefb")
    private List<DeductibleDonation> deductibleDonationIncomeList;

    /**
     * 提前退休一次性补贴
     */
    @JsonProperty("tqtxycxbt")
    private List<ComplexIncome> earlyRetirementList;

    /**
     * 央企负责人绩效薪金延期兑现收入和任期奖励
     */
    @JsonProperty("yqfzrsrhjl")
    private List<ComplexIncome> centralEnterprisesIncomeRewardList;
}
