package cn.com.servyou.dto.tax;

import cn.com.servyou.dto.employee.EmployeeDeclareFeedback;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author pez1420@gmail.com
 * @version $Id: ComplexIncomeResultRequest.java v 0.1 2018/12/14 1:29 AM pez1420 Exp $$
 */
@Data
public class ComplexIncomeResultRequest implements Serializable {

    private static final long serialVersionUID = 8899393392027366715L;

    /**
     * 人员申报失败列表
     */
    @JsonProperty("rysbsblb")
    private List<EmployeeDeclareFeedback> employeeDeclareFeedbacks;

    /**
     * 正常工资薪金(带专项)列表
     */
    @JsonProperty("zcgzxj")
    private ComplexTaxCalculateResult normalSalarySpecIncome;

    /**
     * 无权限正常工资薪金
     */
    @JsonProperty("wqxzcgzxj")
    private ComplexTaxCalculateResult pureSalaryIncome;

    /**
     * 全年一次性奖金收入列表
     */
    @JsonProperty("qnycxjjsslb")
    private ComplexTaxCalculateResult annualOneTimeBonusIncome;

    /**
     * 稿酬所得列表
     */
    @JsonProperty("gcsdlb")
    private ComplexTaxCalculateResult authorsRemunerationIncome;

    /**
     * 劳务报酬所得列表
     */
    @JsonProperty("lwbclb")
    private ComplexTaxCalculateResult laborRemunerationIncome;

    /**
     * 法律援助劳务报酬所得列表
     */
    @JsonProperty("flyzlwbclb")
    private ComplexTaxCalculateResult legalAidLaborRemunerationIncome;

    /**
     * 解除劳动合同一次性补偿金列表
     */
    @JsonProperty("jcldhtycxbcjlb")
    private ComplexTaxCalculateResult compensateIncome;

    /**
     * 内退一次性补偿金列表
     */
    @JsonProperty("ntycxbcjlb")
    private ComplexTaxCalculateResult retreatIncome;

    /**
     * 保险营销员
     */
    @JsonProperty("bxyxy")
    private ComplexTaxCalculateResult insuranceMarketingIncome;

    /**
     * 证券经纪人
     */
    @JsonProperty("zqjjr")
    private ComplexTaxCalculateResult securitiesBrokerIncome;

    /**
     * 特许权所得
     */
    @JsonProperty("txq")
    private ComplexTaxCalculateResult royaltyFee;

    /**
     * 其他连续劳务报酬
     */
    @JsonProperty("qtlxlwbc")
    private ComplexTaxCalculateResult otherContinuationLaborIncome;

    /**
     * 个人股权激励
     */
    @JsonProperty("grgqjl")
    private ComplexTaxCalculateResult stockIncentive;

    /**
     * 企业年金
     */
    @JsonProperty("qynj")
    private ComplexTaxCalculateResult enterpriseAnnuity;

    /**
     * 其他非连续劳务报酬
     */
    @JsonProperty("qtflxlwbc")
    private ComplexTaxCalculateResult otherLabor;

    /**
     * 提前退休一次性补贴
     */
    @JsonProperty("tqtxycxbt")
    private ComplexTaxCalculateResult earlyRetirement;


    /**
     * 央企负责人绩效薪金延期兑现收入和任期奖励
     */
    @JsonProperty("yqfzrsrhjl")
    private ComplexTaxCalculateResult centralEnterprisesIncomeRewardList;
}
