package cn.com.servyou.dto.tax;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @author ranjh
 * @since 20240524
 */
@Data
public class ComplexIncomeVO extends PlatformBaseDataVO {

    /**
     * 所属期
     */
    @JsonProperty("skssq")
    private String period;

    /**
     * 收入
     */
    @JsonProperty("sre")
    private BigDecimal income;

    /**
     * 本月已累计收入
     */
    @JsonProperty("byyljsre")
    private BigDecimal monthAccumulatedIncome;

    /**
     * 免税收入-工资薪金，年终奖金，解除，劳务报酬，稿酬所得
     */
    @JsonProperty("mssd")
    private BigDecimal exemptIncome;

    /**
     * 基本养老保险
     */
    @JsonProperty("jbylaobxf")
    private BigDecimal endowmentInsurance;

    /**
     * 本月累计基本养老保险
     */
    @JsonProperty("byljjbylaobxf")
    private BigDecimal monthEndowmentInsurance;

    /**
     * 基本医疗保险
     */
    @JsonProperty("jbylbxf")
    private BigDecimal medicalInsurance;

    /**
     * 本月累计基本医疗保险
     */
    @JsonProperty("byljjbylbxf")
    private BigDecimal monthMedicalInsurance;

    /**
     * 失业保险
     */
    @JsonProperty("sybxf")
    private BigDecimal unemploymentInsurance;

    /**
     * 本月累计失业保险
     */
    @JsonProperty("byljsybxf")
    private BigDecimal monthUnemploymentInsurance;

    /**
     * 住房公积金
     */
    @JsonProperty("zfgjj")
    private BigDecimal houseProvidentFund;

    /**
     * 本月累计住房公积金
     */
    @JsonProperty("byljzfgjj")
    private BigDecimal monthHouseProvidentFund;

    /**
     * 企业年金/职业年金
     */
    @JsonProperty("nj")
    private BigDecimal annuity;

    /**
     * 月累计企业年金/职业年金
     */
    @JsonProperty("byljnj")
    private BigDecimal monthAnnuity;

    /**
     * 商业健康保险
     */
    @JsonProperty("syjkbx")
    private BigDecimal commercialHealthInsurance;

    /**
     * 月累计商业健康保险
     */
    @JsonProperty("byljsyjkbx")
    private BigDecimal monthCommercialHealthInsurance;

    /**
     * 税延养老保险
     */
    @JsonProperty("syylbx")
    private BigDecimal extensionEndowmentInsurance;

    /**
     * 其他
     */
    @JsonProperty("qt")
    private BigDecimal other;

    /**
     * 月累计其他
     */
    @JsonProperty("byljqt")
    private BigDecimal monthOther;

    /**
     * 准予扣除的捐赠额
     */
    @JsonProperty("zykcjze")
    private BigDecimal deductibleDonation;

    /**
     * 月累计准予扣除的捐赠额
     */
    @JsonProperty("byljzykcjze")
    private BigDecimal monthDeductibleDonation;

    /**
     * 减免税额
     */
    @JsonProperty("jmse")
    private BigDecimal taxDeduction;

    /**
     * 减免税额
     */
    @JsonProperty("byljjmse")
    private BigDecimal monthTaxDeduction;

    /**
     * 备注
     */
    @JsonProperty("bz")
    private String remark;

    /**
     * 允许扣除的税费
     */
    @JsonProperty("yxkcsf")
    private BigDecimal taxDeductible;

    /**
     * 减除费用
     */
    @JsonProperty("jcfy")
    private BigDecimal deductionAmount;

    /**
     * 应纳税所得额
     */
    @JsonProperty("ynssde")
    private BigDecimal taxableIncome;

    /**
     * 应纳税额
     */
    @JsonProperty("ynse")
    private BigDecimal payableAmount;

    /**
     * 已缴税额
     *
     * 财政统发已缴税额只有财政单位才可以填写；界面不支持录入和展示，如果其他界面或者报文要用到默认传0.00
     */
    @JsonProperty("ykjse")
    private BigDecimal paidAmount;

    /**
     * 应扣缴税额
     */
    @JsonProperty("yingkjse")
    private BigDecimal withholdingAmount;

    /**
     * 税率
     */
    @JsonProperty("sl")
    private BigDecimal taxRate;

    /**
     * 速算扣除数
     */
    @JsonProperty("sskcs")
    private BigDecimal quickDeduction;

    /**
     * 所得项目代码
     */
    @JsonProperty("sdxmda")
    private String incomeItemCode;

    /**
     * 所得项目名称-正常工资薪金，全年一次性奖金，解除劳动一次性补偿金，劳务报酬，稿酬所得
     */
    @JsonProperty("sdxm")
    private String incomeItemName;

    /**
     * 部门本月应补退税额
     */
    @JsonProperty("bmbyybtse")
    private BigDecimal actualMonthRefundTax;

    /**
     * 应补退税额
     */
    @JsonProperty("ybtse")
    private BigDecimal refundTax;

    /**
     * 累计收入额
     *
     * 本年累计收入=本期所有的工资薪金所得收入之和+往期工资薪金所得收入之和（见税款计算）
     */
    @JsonProperty("ljsre")
    private BigDecimal accumulatedIncome;

    /**
     * 累计免税收入额
     */
    @JsonProperty("ljmssd")
    private BigDecimal accumulatedExemptIncome;

    /**
     * 累计专项扣除额
     */
    @JsonProperty("ljzxkce")
    private BigDecimal accumulatedSpecDeduction;

    /**
     * 累计专项(附加)扣除额
     */
    @JsonProperty("ljzxfjkce")
    private BigDecimal accumulatedSpecAttachDeduction;

    /**
     * 累计其他扣除额
     */
    @JsonProperty("ljqtkce")
    private BigDecimal accumulatedOtherDeduction;

    /**
     * 累计减免税额
     */
    @JsonProperty("ljjmse")
    private BigDecimal accumulatedTaxDeduction;

    /**
     * 累计减除费用额
     */
    @JsonProperty("ljjcfye")
    private BigDecimal accumulatedDeductionAmount;

    /**
     * 累计应纳税所得额
     */
    @JsonProperty("ljynssde")
    private BigDecimal accumulatedTaxableIncome;

    /**
     * 累计应纳税额
     */
    @JsonProperty("ljynse")
    private BigDecimal accumulatedPayableAmount;

    /**
     * 累计应扣缴税额
     */
    @JsonProperty("ljyingkjse")
    private BigDecimal accumulatedWithholdingAmount;

    /**
     * 累计子女教育支出
     */
    @JsonProperty("ljznjyzc")
    private BigDecimal accumulatedChildEducation;

    /**
     * 累计大病医疗支出
     */
    @JsonProperty("ljdbylzc")
    private BigDecimal accumulatedSeriousIllness;

    /**
     * 累计继续教育支出
     */
    @JsonProperty("ljjxjyzc")
    private BigDecimal accumulatedContinueEducation;

    /**
     * 累计住房租金支出
     */
    @JsonProperty("ljzfzjzc")
    private BigDecimal accumulatedHouseRent;

    /**
     * 累计房屋贷款支出
     */
    @JsonProperty("ljzfdklxzc")
    private BigDecimal accumulatedHouseLoan;

    /**
     * 累计赡养老人支出
     */
    @JsonProperty("ljsylrzc")
    private BigDecimal accumulatedSupportElder;

    /**
     * 累计情况-婴幼儿支出
     */
    @JsonProperty("ljyyezhzc")
    private BigDecimal accumulatedBabyCare;

    /**
     * 累计准予扣除的捐赠额
     */
    @JsonProperty("ljzykcjze")
    private BigDecimal accumulatedDeductibleDonation;

    /**
     * 实际捐赠额
     */
    @JsonProperty("sjjze")
    private BigDecimal actualDonation;

    /**
     * 累计已缴税额
     */
    @JsonProperty("ljykjse")
    private BigDecimal accumulatedPaidAmount;

    /**
     * 专项(附加)扣除合计
     * 本期专项扣除合计=子女教育支出+大病医疗支出+继续教育支出+住房贷款利息支出+住房租金支出+赡养老人支出+婴幼儿照护支出
     */
    /**
     * 专项(附加)扣除合计
     */
    @JsonProperty("zxfjkchj")
    private BigDecimal specAttachDeductionSum;

    /**
     * 专项扣除合计=基本养老保险+基本医疗保险+失业保险+住房公积金
     */
    @JsonProperty("zxkchj")
    private BigDecimal specDeductionSum;

    /**
     * 其他扣除合计=年金+商业健康险+税延养老险+其他
     */
    @JsonProperty("qtckhj")
    private BigDecimal otherDeductionSum;

    /**
     * 本年累计应扣缴税额
     */
    @JsonProperty("ygzsjljykjse")
    private BigDecimal etaxAccumulatedPaidAmount;

    /**
     * 本月已累计扣除税额
     */
    @JsonProperty("byyljkjse")
    private BigDecimal monthAccumulatedWithholdingAmount;

    /**
     * 本次应扣缴税额
     */
    @JsonProperty("bcykjse")
    private BigDecimal currentWithholdingAmount;

    /**
     * 实发工资
     */
    @JsonProperty("sfgz")
    private BigDecimal payroll;

    /**
     * 子女教育支出
     */
    @JsonProperty("znjyzc")
    private BigDecimal childEducationExpenditure;

    /**
     * 赡养老人支出
     */
    @JsonProperty("sylrzc")
    private BigDecimal supportElderExpenditure;

    /**
     * 住房租金支出
     */
    @JsonProperty("zfzjzc")
    private BigDecimal houseRentExpenditure;

    /**
     * 房屋贷款支出
     */
    @JsonProperty("zfdklxzc")
    private BigDecimal houseLoanExpenditure;

    /**
     * 继续教育支出
     */
    @JsonProperty("jxjyzc")
    private BigDecimal continueEducationExpenditure;

    /**
     * 大病医疗支出
     */
    @JsonProperty("dbylzc")
    private BigDecimal seriousIllnessExpenditure;

    /**
     * 婴幼儿照护支出
     */
    @JsonProperty("yyezhzc")
    private BigDecimal babyCareExpenditure;

    //    /**
    //     * 其他信息，暂时只包含部门名称
    //     */
    //    private List<OtherInfoJO> otherInfoList;

    /**
     * 住房公积金上限
     */
    @JsonProperty("zfgjjsx")
    private BigDecimal houseProvidentFundLimit;

    /**
     * 年金上限
     */
    @JsonProperty("njsx")
    private BigDecimal annuityLimit;

    /**
     * 展业成本
     */
    @JsonProperty("zycb")
    private BigDecimal exhibitionCost;

    /**
     * 算税时间
     */
    @JsonProperty("sxsj")
    private Date calculateSalaryTime;

    /**
     * true 标记为总计行
     */
    @JsonIgnore
    private Boolean totalFlag;

    /**
     * 导入数据
     */
    @JsonProperty("drsj")
    private List<String> rowData;
}
