package cn.com.servyou.dto.tax;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * @author pez1420@gmail.com
 * @version $Id: ComplexTaxCalculateResult.java v 0.1 2018/12/14 1:54 AM pez1420 Exp $$
 */
@Data
public class ComplexTaxCalculateResult implements Serializable {

    private static final long serialVersionUID = 87395813913496934L;

    /**
     * 综合算税成功列表
     */
    @JsonProperty("sscglb")
    private List<ComplexIncome> successComplexIncomes;

    /**
     * 综合算税失败薪资列表
     */
    @JsonProperty("sssblb")
    private List<ComplexIncome> failedComplexIncomes;

    /**
     * 失败算税原因列表
     */
    @JsonProperty("sssbyylb")
    private List<CheckTaxCalResult> failedCheckTaxCalResult;

    /**
     * 算税总人数
     */
    @JsonProperty("sszrs")
    private Integer totalPeople;

    /**
     * 算税失败人数
     */
    @JsonProperty("sssbrs")
    private Integer failedPeople;

    /**
     * 年金上限
     */
    @JsonProperty("njsx")
    private BigDecimal annuityLimit;

    /**
     * 公积金上限
     */
    @JsonProperty("zfgjjsx")
    private BigDecimal houseProvidentFundLimit;

    /**
     * 年平均工资
     */
    @JsonProperty("npjgz")
    private BigDecimal averageAnnual;

    /**
     * 企业在电子税务局上月是否已申报(仅正常工资薪金有效):
     *
     * 0：表示上月未申报
     *
     * 1：表示上月已申报
     *
     * 2：上上月未申报
     */
    @JsonProperty("qysysfysb")
    private String etaxDeclaredLastMonth;

}
