package cn.com.servyou.dto.tax;

import cn.com.servyou.dto.tax.deduction.ChildEducationSpecialDeduction;
import cn.com.servyou.dto.tax.deduction.ContinueEducationSpecialDeduction;
import cn.com.servyou.dto.tax.deduction.HouseLoanSpecialDeduction;
import cn.com.servyou.dto.tax.deduction.HouseRentSpecialDeduction;
import cn.com.servyou.dto.tax.deduction.SeriousIllnessSpecialDeduction;
import cn.com.servyou.dto.tax.deduction.SupportElderSpecialDeduction;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.util.List;

/**
 * 人员详情和专项扣除
 *
 * @author zhouww
 * @version $Id: DetailCompanyEmployee.java v 0.1 2018/12/3 下午2:05 YuJiaqi Exp $$
 */
@Data
public class DetailCompanyEmployee extends CompanyEmployee {

    private static final long serialVersionUID = 5906094067268857087L;

    /**
     * 子女教育专项扣除
     */
    @JsonProperty("znjys")
    private List<ChildEducationSpecialDeduction> childEducationList;

    /**
     * 赡养老人专项扣除
     */
    @JsonProperty("sylrs")
    private SupportElderSpecialDeduction supportElder;

    /**
     * 房屋租赁专项扣除
     */
    @JsonProperty("fwzls")
    private List<HouseRentSpecialDeduction> houseRentList;

    /**
     * 房屋贷款专项扣除
     */
    @JsonProperty("fwdks")
    private List<HouseLoanSpecialDeduction> houseLoanList;

    /**
     * 继续教育专项扣除
     */
    @JsonProperty("jxjys")
    private List<ContinueEducationSpecialDeduction> continueEducationList;

    /**
     * 大病医疗支出专项扣除
     */
    @JsonProperty("dbyls")
    private List<SeriousIllnessSpecialDeduction> seriousIllnessList;

    /**
     * 婴幼儿照护
     */
    @JsonProperty("yyezhls")
    private List<BabyCareSpecialDeduction> babyCareSpecialDeductionList;

}
