/**
 * cn.com.servyou.com.cn Inc.
 * Copyright (c) 1999-2019 All Rights Reserved.
 */

package cn.com.servyou.dto.tax;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 免税事项附表
 *
 * @author xingting
 * @version 2019-07-18 11:38 xingting
 */
@Data
public class ExemptIncome {

    /**
     * 人员姓名
     */
    @JsonProperty("xm")
    private String employeeName;

    /**
     * 证件类型
     */
    @JsonProperty("zzlx")
    private String licenseType;

    /**
     * 证件号码
     */
    @JsonProperty("zzhm")
    private String licenseNumber;

    /**
     * 所得项目
     */
    @JsonProperty("sdxm")
    private String incomeItemName;

    /**
     * 减免事项
     */
    @JsonProperty("jmsx")
    private String deductionItem;

    /**
     * 减免性质
     */
    @JsonProperty("jmxz")
    private String deductionNature;

    /**
     * 实际扣除金额
     */
    @JsonProperty("sjkcje")
    private BigDecimal deductionAmount;
}
