package cn.com.servyou.dto.tax;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 税延养老保险
 *
 * @author zhouww
 * @version $Id: ExtensionEndowmentInsurance.java v 0.1 2019/3/21 11:52 PM YuJiaqi Exp $$
 */
@Data
public class ExtensionEndowmentInsurance implements Serializable {

    /**
     * 人员姓名
     */
    @JsonProperty("xm")
    private String employeeName;

    /**
     * 证件类型
     */
    @JsonProperty("zzlx")
    private String licenseType;

    /**
     * 证件号码
     */
    @JsonProperty("zzhm")
    private String licenseNumber;

    /**
     * 申报扣除月份
     */
    @JsonProperty("sbkcyf")
    private String deductionPeriod;

    /**
     * 税延养老账号编号
     */
    @JsonProperty("syylzhbh")
    private String extensionNumber;

    /**
     * 报税校验码
     */
    @JsonProperty("bsjym")
    private String reportVerificationCode;

    /**
     * 年度保费
     */
    @JsonProperty("ndbf")
    private BigDecimal annualPremium;

    /**
     * 月度保费
     */
    @JsonProperty("ydbf")
    private BigDecimal monthlyPremium;

    /**
     * 实际扣除金额
     */
    @JsonProperty("sjkcje")
    private BigDecimal deductionAmount;
}
