package cn.com.servyou.dto.tax;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 减免事项附表
 *
 * @author zhouww
 * @version $Id: IncomeDeduction.java v 0.1 2019/3/21 11:28 PM YuJiaqi Exp $$
 */
@Data
public class IncomeDeduction implements Serializable {

    /**
     * 人员姓名
     */
    @JsonProperty("xm")
    private String employeeName;

    /**
     * 证件类型
     */
    @JsonProperty("zzlx")
    private String licenseType;

    /**
     * 证件号码
     */
    @JsonProperty("zzhm")
    private String licenseNumber;

    /**
     * 所得项目
     */
    @JsonProperty("sdxm")
    private String incomeItemName;

    /**
     * 减免事项
     */
    @JsonProperty("jmsx")
    private String deductionItem;

    /**
     * 减免性质
     */
    @JsonProperty("jmxz")
    private String deductionNature;

    /**
     * 实际扣除金额
     */
    @JsonProperty("sjkcje")
    private BigDecimal deductionAmount;
}
