package cn.com.servyou.dto.tax;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author zhouww
 * @version $Id: Insurance.java v 0.1 2019/3/21 11:09 PM YuJiaqi Exp $$
 */
@Data
public class Insurance implements Serializable {

    private static final long serialVersionUID = 6958574988905955381L;

    /**
     * 人员姓名
     */
    @JsonProperty("xm")
    private String employeeName;

    /**
     * 证件类型
     */
    @JsonProperty("zzlx")
    private String licenseType;

    /**
     * 证件号码
     */
    @JsonProperty("zzhm")
    private String licenseNumber;

    /**
     * 保单生效日期
     */
    @JsonProperty("bdsxrq")
    private String effectiveDate;

    /**
     * 税优识别码
     */
    @JsonProperty("sysbm")
    private String preferenceCode;

    /**
     * 年度保费
     */
    @JsonProperty("ndbf")
    private BigDecimal annualPremium;

    /**
     * 月度保费
     */
    @JsonProperty("ydbf")
    private BigDecimal monthlyPremium;

    /**
     * 实际扣除金额
     */
    @JsonProperty("sjkcje")
    private BigDecimal deductionAmount;
}
