package cn.com.servyou.dto.tax;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author zhouww
 * @version 保险营销员劳务报酬
 */
@Data
public class InsuranceMarketingIncome extends TaxStrategy implements Serializable {

    private static final long serialVersionUID = 2086543571832962480L;

    /**
     * 保险营销员劳务报酬
     */
    @JsonProperty("bxyxylwbclb")
    private List<ComplexIncome> insuranceMarketingIncomeList;

    /**
     * 上月保险营销员劳务报酬列表
     * <p>
     * 1、若当月已经申报完毕（当月申报上月所得），那么能从局端下发累计到上月的所得数据，此时传给局端的所得月份为当前月份
     * <p>
     * 2、若当月未申报完毕（当月申报上月所得），那么能从局端下发累计到上月-1的所属数据，此时传给局端的所得月份为当月月份-1
     */
    @JsonProperty("sybxyxylwbclb")
    private List<ComplexIncome> lastMonthSalary;
}
