package cn.com.servyou.dto.tax;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author pez1420@gmail.com
 * @version $Id: NonResidentsCalculateResult.java v 0.1 2018/12/14 1:51 AM pez1420 Exp $$
 */
@Data
public class NonResidentsCalculateResult implements Serializable {

    private static final long serialVersionUID = 2031033134768017268L;

    /**
     * 非居民-算税成功列表
     */
    @JsonProperty("sscglb")
    private List<NonResidentsIncome> successNonResidentsIncomes;

    /**
     * 非居民-算税失败薪资列表
     */
    @JsonProperty("sssblb")
    private List<NonResidentsIncome> failedNonResidentsIncomes;

    /**
     * 非居民-失败算税原因列表
     */
    @JsonProperty("sssbyylb")
    private List<CheckTaxCalResult> failedCheckTaxCalResult;

    /**
     * 算税总人数
     */
    @JsonProperty("sszrs")
    private Integer totalPeople;

    /**
     * 算税失败人数
     */
    @JsonProperty("sssbrs")
    private Integer failedPeople;
}
