package cn.com.servyou.dto.tax;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 非居民所得
 *
 * @author zhouww
 * @version 20191016
 */
@Data
public class NonResidentsIncome extends BaseEmp {

    private static final long serialVersionUID = 8417884667381154543L;

    /**
     * 是否自动生成附表
     * 只对解除劳动合同一次性补偿金和稿酬所得生效
     */
    @JsonProperty("sfzdscmsfb")
    private String isAutoGenerateExempt;

    /**
     * 所属期
     */
    @JsonProperty("skssq")
    private String period;

    /**
     * 收入额/全年一次性奖金额
     */
    @JsonProperty("sre")
    private BigDecimal income;

    /**
     * 累计收入（不含本次）
     */
    @JsonProperty("ljsre")
    private BigDecimal accumulateIncome;

    /**
     * 免税收入
     */
    @JsonProperty("mssd")
    private BigDecimal exemptIncome;

    /**
     * 财产原值
     */
    @JsonProperty("ccyz")
    private BigDecimal propertyValue;

    /**
     * 允许扣除的税费
     */
    @JsonProperty("yxkcsf")
    private BigDecimal taxDeductible;

    /**
     * 投资抵扣
     */
    @JsonProperty("tzdk")
    private BigDecimal investmentDeduction;

    /**
     * 其他
     */
    @JsonProperty("qt")
    private BigDecimal other;

    /**
     * 备注
     */
    @JsonProperty("bz")
    private String remark;

    /**
     * 实际工作年限
     */
    @JsonProperty("sjgznxs")
    private BigDecimal workedYear;

    /**
     * 月工资薪金所得与法定减除费用额差额
     */
    @JsonProperty("ygzxjsdyfdjcfyece")
    private BigDecimal salaryDeductionBalance;

    /**
     * 减除费用
     */
    @JsonProperty("jcfy")
    private BigDecimal deductionAmount;

    //    /**
    //     * 实际捐赠额
    //     */
    //    @JsonProperty("sjjze")
    //    private BigDecimal actualDonation;
    //
    //    /**
    //     * 捐赠方式
    //     */
    //    @JsonProperty("jzlx")
    //    private String donationType;

    /**
     * 准予扣除的捐赠额
     */
    @JsonProperty("zykcjze")
    private BigDecimal deductibleDonation;

    /**
     * 税前扣除项目合计
     */
    @JsonProperty("sqkcxmhj")
    private BigDecimal pretaxDeductionSum;

    /**
     * 应纳税额所得额
     */
    @JsonProperty("ynssde")
    private BigDecimal taxableIncome;

    /**
     * 应纳税额
     */
    @JsonProperty("ynse")
    private BigDecimal payableAmount;

    /**
     * 减免税额
     */
    @JsonProperty("jmse")
    private BigDecimal taxDeduction;

    /**
     * 应扣缴税额
     */
    @JsonProperty("yingkjse")
    private BigDecimal withholdingAmount;

    /**
     * 已扣缴税额
     */
    @JsonProperty("ykjse")
    private BigDecimal paidAmount;

    /**
     * 税率
     */
    @JsonProperty("sl")
    private BigDecimal taxRate;

    /**
     * 速算扣除数
     */
    @JsonProperty("sskcs")
    private BigDecimal quickDeduction;

    /**
     * 申报方式
     */
    @JsonProperty("sbfs")
    private String declarationWay;

    /**
     * 应补退税额
     */
    @JsonProperty("ybtse")
    private BigDecimal refundTax;

    /**
     * 所得项目代码
     */
    @JsonProperty("sdxmda")
    private String incomeItemCode;

    /**
     * 非居民所得薪金类别-正常工资薪金，全年一次性奖金，解除劳动一次性补偿金，劳务报酬，稿酬所得，利息股息红利，股权转让所得，其他财产转让所得，偶然所得，其他所得
     */
    @JsonProperty("sdxm")
    private String incomeItemName;

    /**
     * 所得期间起
     */
    @JsonProperty("sdqjq")
    private String incomePeriodStart;

    /**
     * 所得期间止
     */
    @JsonProperty("sdqjz")
    private String incomePeriodEnd;

    /**
     * 更正标志
     * 默认正常申报0, 更正1
     */
    @JsonProperty("gzbz")
    private String backupType;

    /**
     * 试用公式
     */
    @JsonProperty("sygs")
    private String formula;

    /**
     * 境内工作天数
     */
    @JsonProperty("jngzts")
    private BigDecimal domesticWorkingDays;

    /**
     * 境外工作天数
     */
    @JsonProperty("jwgzts")
    private BigDecimal abroadWorkingDays;

    /**
     * 境外支付
     */
    @JsonProperty("jwzf")
    private BigDecimal abroadIncome;

    /**
     * 境内支付
     */
    @JsonProperty("jnzf")
    private BigDecimal domesticIncome;

    /**
     * 被投资企业所在省（市）代码
     */
    @JsonProperty("btzqyszsdm")
    private String areaCode;

    /**
     * 被投资企业登记序号
     */
    @JsonProperty("btzqydjxh")
    private String registrationNumber;

    /**
     * 被投资企业统一社会信用代码
     */
    @JsonProperty("btzqyshxydm")
    private String taxNo;

    /**
     * 被投资企业名称
     */
    @JsonProperty("btzqymc")
    private String companyName;

    /**
     * 股权转让时间
     */
    @JsonProperty("gqzrsj")
    private String equityTransferDate;
}
