package cn.com.servyou.dto.tax;

import cn.com.servyou.dto.tax.deduction.DeductibleDonation;
import cn.com.servyou.dto.tax.deduction.StockholderEquityTransferRequestVO;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.util.List;

/**
 * @author zhouww
 * @version 20191016
 */
@Data
public class NonResidentsIncomeRequest extends BaseIncomeRequest {

    private static final long serialVersionUID = -6385201922329707548L;

    /**
     * 正常工资薪金（外籍人工资薪金）列表
     */
    @JsonProperty("wjgzxjlb")
    private List<NonResidentsIncome> foreignerWagesSalaryIncomes;

    /**
     * 外籍人员数月奖金列表
     */
    @JsonProperty("wjrysyjjlb")
    private List<NonResidentsIncome> foreignerMonthsBonusIncomes;

    /**
     * 劳务报酬列表
     */
    @JsonProperty("lwbclb")
    private List<NonResidentsIncome> laborRemunerationIncomes;

    /**
     * 稿酬所得列表
     */
    @JsonProperty("gcsdlb")
    private List<NonResidentsIncome> authorsRemunerationIncome;

    /**
     * 利息股息红利所得列表
     */
    @JsonProperty("lxgxhllb")
    private List<NonResidentsIncome> interestDividendBonusIncomes;

    /**
     * 股权转让所得列表
     */
    @JsonProperty("gqzrlb")
    private List<NonResidentsIncome> equitytTransferIncomes;

    /**
     * 其他财产转让所得列表
     */
    @JsonProperty("qtcczrlb")
    private List<NonResidentsIncome> otherPropertyAssignmentIncomes;

    /**
     * 偶然所得列表
     */
    @JsonProperty("orsdlb")
    private List<NonResidentsIncome> accidentalIncome;

    /**
     * 解除劳动补偿金列表
     */
    @JsonProperty("jcldhtycxbcjlb")
    private List<NonResidentsIncome> compensateIncomes;

    /**
     * 保险营销员
     */
    @JsonProperty("bxyxy")
    private List<NonResidentsIncome> insuranceSalesmenIncome;

    /**
     * 证卷经纪人
     */
    @JsonProperty("zqjjr")
    private List<NonResidentsIncome> securitiesBrokerIncome;

    /**
     * 股权激励所得
     */
    @JsonProperty("grgqjl")
    private List<NonResidentsIncome> equityIncentiveIncome;

    /**
     * 减免附表列表
     */
    @JsonProperty("jmfblb")
    private List<IncomeDeduction> incomeDeductionList;

    /**
     * 免税附表列表
     */
    @JsonProperty("msfblb")
    private List<ExemptIncome> exemptIncomeList;

    /**
     * 准予扣除的捐赠额附表
     */
    @JsonProperty("zykcjzefb")
    private List<DeductibleDonation> deductibleDonationIncomeList;

    /**
     * 特许权使用费所得
     */
    @JsonProperty("txqsyfsd")
    private List<NonResidentsIncome> concessionIncome;

    /**
     * 个人房屋出租所得
     */
    @JsonProperty("grfwczsd")
    private List<NonResidentsIncome> housingRentIncome;

    /**
     * 股东股权转让附表
     */
    @JsonProperty("gdgqzrfb")
    private List<StockholderEquityTransferRequestVO> stockholderEquityTransferRequestList;
}
