package cn.com.servyou.dto.tax;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author pez1420@gmail.com
 * @version $Id: NonResidentsIncomeResultRequest.java v 0.1 2018/12/14 1:29 AM pez1420 Exp $$
 */
@Data
public class NonResidentsIncomeResultRequest implements Serializable {

    private static final long serialVersionUID = 1180951866770170951L;

    /**
     * 正常工资薪金（外籍人工资薪金）列表
     */
    @JsonProperty("wjgzxjlb")
    private NonResidentsCalculateResult foreignerWagesSalaryIncomes;

    /**
     * 外籍人员数月奖金
     */
    @JsonProperty("wjrysyjjlb")
    private NonResidentsCalculateResult foreignerMonthsBonusIncomes;

    /**
     * 劳务报酬列表
     */
    @JsonProperty("lwbclb")
    private NonResidentsCalculateResult laborRemunerationIncomes;

    /**
     * 稿酬所得列表
     */
    @JsonProperty("gcsdlb")
    private NonResidentsCalculateResult authorsRemunerationIncome;

    /**
     * 利息股息红利所得列表
     */
    @JsonProperty("lxgxhllb")
    private NonResidentsCalculateResult interestDividendBonusIncomes;

    /**
     * 股权转让所得列表
     */
    @JsonProperty("gqzrlb")
    private NonResidentsCalculateResult equitytTransferIncomes;

    /**
     * 其他财产转让所得列表
     */
    @JsonProperty("qtcczrlb")
    private NonResidentsCalculateResult otherPropertyAssignmentIncomes;

    /**
     * 偶然所得列表
     */
    @JsonProperty("orsdlb")
    private NonResidentsCalculateResult accidentalIncome;

    /**
     * 解除劳动合同补偿金
     */
    @JsonProperty("jcldhtycxbcjlb")
    private NonResidentsCalculateResult compensateIncome;

    /**
     * 保险营销员
     */
    @JsonProperty("bxyxy")
    private NonResidentsCalculateResult insuranceSalesmenIncome;

    /**
     * 证卷经纪人
     */
    @JsonProperty("zqjjr")
    private NonResidentsCalculateResult securitiesBrokerIncome;

    /**
     * 股权激励所得
     */
    @JsonProperty("grgqjl")
    private NonResidentsCalculateResult equityIncentiveIncome;

    /**
     * 个人房屋出租所得
     */
    @JsonProperty("grfwczsd")
    private NonResidentsCalculateResult housingRentIncome;

    /**
     * 特许权使用费所得
     */
    @JsonProperty("txqsyfsd")
    private NonResidentsCalculateResult concessionIncome;
}
