package cn.com.servyou.dto.tax;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author zhouww
 * @since 20191016
 */
@Data
public class NormalSalarySpecIncome extends TaxStrategy implements Serializable {

    private static final long serialVersionUID = -4815392512423739206L;

    /**
     * 正常工资薪    金(带专项)列表
     */
    @JsonProperty("zcgzxjlb")
    private List<ComplexIncome> normalSalarySpec;

    /**
     * 上月正常工资薪金(带专项)列表
     * <p>
     * 1、若当月已经申报完毕（当月申报上月所得），那么能从局端下发累计到上月的所得数据，此时传给局端的所得月份为当前月份
     * <p>
     * 2、若当月未申报完毕（当月申报上月所得），那么能从局端下发累计到上月-1的所属数据，此时传给局端的所得月份为当月月份-1
     */
    @JsonProperty("syzcgzxjlb")
    private List<ComplexIncome> lastMonthNormalSalary;
}

