package cn.com.servyou.dto.tax;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.List;

/**
 * 其他连续劳务报酬所得
 *
 * @author zhouww
 * @since 20200917
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class OtherContinuationLaborIncome extends TaxStrategy implements Serializable {

    private static final long serialVersionUID = 780372586737088500L;

    /**
     * 其他连续劳务报酬所得
     */
    @JsonProperty("qtlxlwbclb")
    private List<ComplexIncome> otherContinuationLaborIncomeList;

    /**
     * 上月其他连续劳务报酬所得
     * <p>
     * 1、若当月已经申报完毕（当月申报上月所得），那么能从局端下发累计到上月的所得数据，此时传给局端的所得月份为当前月份
     * <p>
     * 2、若当月未申报完毕（当月申报上月所得），那么能从局端下发累计到上月-1的所属数据，此时传给局端的所得月份为当月月份-1
     */
    @JsonProperty("syqtlxlwbclb")
    private List<ComplexIncome> lastMonthIncomeList;

}
