package cn.com.servyou.dto.tax;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 往期历史数据
 *
 * @author zhouww
 * @version 20191016
 */
@Data
public class PastHistoryData implements Serializable {

    private static final long serialVersionUID = 8614031815723896423L;

    /**
     * 序号
     */
    @JsonProperty("xh")
    private Integer xh;

    /**
     * 姓名
     */
    @JsonProperty("xm")
    private String xm;

    /**
     * 身份证件类型(中文)
     */
    @JsonProperty("zzlx")
    private String sfzjlxmc;

    /**
     * 身份证件号码
     */
    @JsonProperty("zzhm")
    private String sfzjhm;

    /**
     * 国籍（地区）
     */
    @JsonProperty("gj")
    private String gjhdqmc;

    /**
     * 自然人登记序号
     */
    @JsonProperty("zrrdjxh")
    private String zrrdjxh;

    /**
     * 自然人档案号
     */
    @JsonProperty("zrrdah")
    private String zrrdah;

    /**
     * 所得项目代码(中文)
     */
    @JsonProperty("sdxm")
    private String sdxmDm;

    /**
     * 累计收入额
     */
    @JsonProperty("ljsre")
    private BigDecimal ljsre;

    /**
     * 累计免税收入
     */
    @JsonProperty("ljmssr")
    private BigDecimal ljmssr;

    /**
     * 累计专项扣除合计
     */
    @JsonProperty("ljzxkchj")
    private BigDecimal ljzxkcHj;

    /**
     * 类及其他扣除合计
     */
    @JsonProperty("ljqtkchj")
    private BigDecimal ljqtkcHj;

    /**
     * 累计子女教育支出
     */
    @JsonProperty("ljznjyzc")
    private BigDecimal ljznjyzc = BigDecimal.ZERO;

    /**
     * 累计赡养老人支出
     */
    @JsonProperty("ljsylrzc")
    private BigDecimal ljsylrzc = BigDecimal.ZERO;

    /**
     * 累计住房贷款利息支出
     */
    @JsonProperty("ljzfdklxzc")
    private BigDecimal ljzfdklxzc = BigDecimal.ZERO;

    /**
     * 累计住房租金支出
     */
    @JsonProperty("ljzfzjzc")
    private BigDecimal ljzfzjzc = BigDecimal.ZERO;

    /**
     * 累计继续教育支出
     */
    @JsonProperty("ljjxjyzc")
    private BigDecimal ljjxjyzc = BigDecimal.ZERO;

    /**
     * 累计专项附加扣除合计
     */
    @JsonProperty("ljzxfjkchj")
    private BigDecimal ljzxfjkcHj = BigDecimal.ZERO;

    /**
     * 累计准予扣除的捐赠额
     */
    @JsonProperty("ljzykcdjze")
    private BigDecimal ljzykcdjze;

    /**
     * 累计减免税额
     */
    @JsonProperty("ljjmse")
    private BigDecimal ljjmse;

    /**
     * 累计已预缴税额
     */
    @JsonProperty("ljyiyujse")
    private BigDecimal ljyiyujse;

    /**
     * 累计已减除费用额
     */
    @JsonProperty("ljfy")
    private BigDecimal ljfy;
}
