package cn.com.servyou.dto.tax;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author zhouww
 * @version 20191016
 */
@Data
public class PureSalary implements Serializable {

    private static final long serialVersionUID = -904463753003241068L;

    /**
     * 往期历史申报数据列表
     */
    @JsonProperty("wqlssbsjlb")
    private List<PastHistoryData> pastHistoryDatas;

    /**
     * 正常工资薪金列表
     */
    @JsonProperty("zcgzxjlb")
    private List<ComplexIncome> normalSalarys;

    /**
     * 累计专项扣除对象
     */
    @JsonProperty("ljzxkc")
    private List<SpecialDeduction> specialDeductions;

    /**
     * 专项附加扣除标记
     */
    @JsonProperty("zxkcbz")
    private String specialDeductionFlag;

    /**
     * 年金住房公积金算税上限选项
     */
    @JsonProperty("njzfgjjsxxx")
    private String annuityAndHouseProvidentFundOption;
}
