package cn.com.servyou.dto.tax;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * 限售股所得收入
 *
 * @author zhouww
 * @since 20201224
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class RestrictedStockIncome extends BaseEmp {

    /**
     * 证券账户号
     */
    @JsonProperty("zqzhh")
    private String securitiesAccountNumber;

    /**
     * 股票代码
     */
    @JsonProperty("gpdm")
    private String stockCode;

    /**
     * 股票名称
     */
    @JsonProperty("gpmc")
    private String stockName;

    /**
     * 每股计税价格(六位小数)
     */
    @JsonProperty("mgjsjg")
    private BigDecimal perStockTaxablePrice;

    /**
     * 转让股数
     */
    @JsonProperty("zrgs")
    private Integer transferStockNumber;

    /**
     * 限售股原值
     */
    @JsonProperty("xsgyz")
    private BigDecimal originalValue;

    /**
     * 合理税费
     */
    @JsonProperty("hlsf")
    private BigDecimal tax;

    /**
     * 备注
     */
    @JsonProperty("bz")
    private String remark;

    /**
     * 准予扣除的捐赠额
     */
    @JsonProperty("zykcjze")
    private BigDecimal deductibleDonation;
}
