package cn.com.servyou.dto.tax;

import cn.com.servyou.dto.tax.deduction.DeductibleDonation;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 限售股所得
 *
 * @author zhouww
 * @since 20201224
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class RestrictedStockIncomeRequest extends BaseIncomeRequest {

    /**
     * 限售股所得
     */
    @JsonProperty("xsgsdlb")
    private List<RestrictedStockIncome> restrictedStockIncomeList;

    /**
     * 企业人员列表
     */
    @JsonProperty("rylb")
    private List<DetailCompanyEmployee> companyEmployeeList;

    /**
     * 离职日期处理策略
     */
    @JsonProperty("lzrqcl")
    private String resignDateStrategy;

    /**
     * 是否需要人员申报
     * 0：人员不申报 1：人员申报
     */
    @JsonProperty("sfrysb")
    private String declareEmployeeOption;

    /**
     * 准予扣除的捐赠额附表
     */
    @JsonProperty("zykcjzefb")
    private List<DeductibleDonation> deductibleDonationIncomeList;
}
