package cn.com.servyou.dto.tax;

import cn.com.servyou.dto.employee.EmployeeDeclareFeedback;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 限售股所得算税结果
 *
 * @author zhouww
 * @since 20201224
 */
@Data
public class RestrictedStockIncomeResult implements Serializable {

    private static final long serialVersionUID = 4926934528735124609L;

    /**
     * 人员申报失败列表
     */
    @JsonProperty("rysbsblb")
    private List<EmployeeDeclareFeedback> employeeDeclareFeedbackList;

    /**
     * 限售股所得-算税成功列表
     */
    @JsonProperty("sscglb")
    private List<RestrictedStockPersonResult> successResultList;

    /**
     * 限售股所得-算税失败薪资列表
     */
    @JsonProperty("sssblb")
    private List<RestrictedStockIncome> failedResultList;

    /**
     * 限售股所得-失败算税原因列表
     */
    @JsonProperty("sssbyylb")
    private List<CheckTaxCalResult> failedCheckTaxCalResultList;

    /**
     * 算税总人数
     */
    @JsonProperty("sszrs")
    private Integer totalPeople;

    /**
     * 算税失败人数
     */
    @JsonProperty("sssbrs")
    private Integer failedPeople;
}
