package cn.com.servyou.dto.tax;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 限售股所得 个人算税结果
 *
 * @author zhouww
 * @since 20201224
 */
@Data
public class RestrictedStockPersonResult extends BaseEmp {

    /**
     * 证券账户号
     */
    @JsonProperty("zqzhh")
    private String securitiesAccountNumber;

    /**
     * 股票代码
     */
    @JsonProperty("gpdm")
    private String stockCode;

    /**
     * 股票名称
     */
    @JsonProperty("gpmc")
    private String stockName;

    /**
     * 每股计税价格(六位小数)
     */
    @JsonProperty("mgjsjg")
    private BigDecimal perStockTaxablePrice;

    /**
     * 转让股数
     */
    @JsonProperty("zrgs")
    private Integer transferStockNumber;

    /**
     * 限售股原值
     */
    @JsonProperty("xsgyz")
    private BigDecimal originalValue;

    /**
     * 转让收入
     */
    @JsonProperty("zrsr")
    private BigDecimal income;

    /**
     * 合理税费
     */
    @JsonProperty("hlsf")
    private BigDecimal tax;

    /**
     * 扣除及减除项目合计
     */
    @JsonProperty("kcjjcxmhj")
    private BigDecimal deductionSum;

    /**
     * 应纳税所得额
     */
    @JsonProperty("ynssde")
    private BigDecimal taxableIncome;

    /**
     * 税率
     */
    @JsonProperty("sl")
    private BigDecimal taxRate;

    /**
     * 应扣缴税额
     */
    @JsonProperty("kjse")
    private BigDecimal withholdingAmount;
}
