package cn.com.servyou.dto.tax;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author zhouww
 * @version 2019-06-03
 */
@Data
public class SecuritiesBrokerIncome extends TaxStrategy implements Serializable {

    private static final long serialVersionUID = -1736243050324804413L;

    /**
     * 证券经纪人所得
     */
    @JsonProperty("zqjjrsdlb")
    private List<ComplexIncome> securitiesBrokerIncomeList;

    /**
     * 上月证券经纪人列表
     * <p>
     * 1、若当月已经申报完毕（当月申报上月所得），那么能从局端下发累计到上月的所得数据，此时传给局端的所得月份为当前月份
     * <p>
     * 2、若当月未申报完毕（当月申报上月所得），那么能从局端下发累计到上月-1的所属数据，此时传给局端的所得月份为当月月份-1
     */
    @JsonProperty("syzqjjrlb")
    private List<ComplexIncome> lastMonthSalary;

}
