package cn.com.servyou.dto.tax;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;

/*********************************
 * @author liujinliang
 * @describe 专项数据明细
 * @version：SpecialDataSourceDetail.java 2019-04-18 11:28
 *********************************/

@Data
public class SpecialDataSourceDetail implements Serializable {

    private static final long serialVersionUID = -1997769461901304566L;

    /**
     * 纳税人采集
     */
    @JsonProperty("cnrcj")
    private Integer app;

    /**
     * 扣缴义务人（已报送局端）
     */
    @JsonProperty("kjywrybs")
    private Integer withholdingCloud;

    /**
     * 扣缴义务人（未报送局端）
     */
    @JsonProperty("kjywrwbs")
    private Integer withholdingLocal;

    /**
     * 其他
     */
    @JsonProperty("other")
    private Integer other;
}
