package cn.com.servyou.dto.tax;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;

/*********************************
 * @author liujinliang
 * @describe 专项扣除数据来源统计
 * @version：ComplexIncomeAccount.java 2019-04-16 20:28
 *********************************/

@Data
public class SpecialDataSourceStatistics implements Serializable {

    private static final long serialVersionUID = 6084495947727626263L;

    /**
     * 子女教育数据来源统计
     */
    @JsonProperty("znjyzxsjly")
    private SpecialDataSourceDetail childEducationSpecialDeductionStatistics;

    /**
     * 继续教育数据来源统计
     */
    @JsonProperty("jxjyzxsjly")
    private SpecialDataSourceDetail continueEducationSpecialDeductionStatistics;

    /**
     * 住房贷款数据来源统计
     */
    @JsonProperty("zfdkzxsjly")
    private SpecialDataSourceDetail houseLoanSpecialDeductionStatistics;

    /**
     * 住房租金数据来源统计
     */
    @JsonProperty("zfzjzxsjly")
    private SpecialDataSourceDetail houseRentSpecialDeductionStatistics;

    /**
     * 赡养老人数据来源统计
     */
    @JsonProperty("sylrzxsjly")
    private SpecialDataSourceDetail supportElderSpecialDeductionStatistics;

}
