package cn.com.servyou.dto.tax;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author zhouww
 * @version 20191016
 */
@Data
public class SpecialDeduction implements Serializable {

    private static final long serialVersionUID = 7842995078505849741L;

    /**
     * 姓名
     */
    @JsonProperty("xm")
    private String xm;

    /**
     * 身份证件类型代码
     */
    @JsonProperty("zzlx")
    private String sfzjlxdm;

    /**
     * 身份证件号码
     */
    @JsonProperty("zzhm")
    private String sfzjhm;

    /**
     * 所得项目代码(中文)
     */
    @JsonProperty("sdxm")
    private String sdxmDm;

    /**
     * 累计子女教育支出
     */
    @JsonProperty("ljznjyzc")
    private BigDecimal ljznjyzc;

    /**
     * 累计赡养老人支出
     */
    @JsonProperty("ljsylrzc")
    private BigDecimal ljsylrzc;

    /**
     * 累计住房贷款利息支出
     */
    @JsonProperty("ljzfdklxzc")
    private BigDecimal ljzfdklxzc;

    /**
     * 累计住房租金支出
     */
    @JsonProperty("ljzfzjzc")
    private BigDecimal ljzfzjzc;

    /**
     * 累计继续教育支出
     */
    @JsonProperty("ljjxjyzc")
    private BigDecimal ljjxjyzc;

    /**
     * 累计专项附加扣除合计
     */
    @JsonProperty("ljzxfjkchj")
    private BigDecimal ljzxfjkcHj;

}
