package cn.com.servyou.dto.tax;

import cn.com.servyou.dto.enums.PersonalPensionOptionEnum;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author zhouww
 * @since 2019-06-10
 */
@Data
public class TaxStrategy implements Serializable {

    /**
     * 企业人员列表
     */
    @JsonProperty("rylb")
    private List<DetailCompanyEmployee> companyEmployeeList;

    /**
     * 往期历史申报数据列表
     */
    @JsonProperty("wqlssbsjlb")
    private List<PastHistoryDataPair> pastHistoryDataPairs;

    /**
     * 正常工资薪金是否需要专项
     * 如果zcgzxjsfxyzx的值为1， 那么专项累计值以用户传入的数据为主
     */
    @JsonProperty("zcgzxjsfxyzx")
    private String zcgzxjsfxyzx;

    /**
     * 正常工资薪金是否传入累计（申报/单月计算时使用）
     * 0：使用下载计算专项累计  1：使用传入的专项累计
     */
    @JsonProperty("zcgzxjsfcrlj")
    private String zcgzxjsfcrlj;

    /**
     * 支持上月传专项或者累计专项金额（两个月算税场景）
     * 0：不支持用户传专项  默认值
     * 1：支持传上月当月的专项（默认为0）
     * 2：支持传截止至上月为止的累计专项
     */
    @JsonProperty("zcgzxjsfcrzx")
    private String zcgzxjsfcrzx;

    /**
     * 是否已申报上月正常工资薪金（两个月算税场景）
     * 0：上月未申报 1：上月已申报
     */
    @JsonProperty("syysfsyzcgzxj")
    private String declaredLastMonth;

    /**
     * 企业下载往期标志位
     */
    @JsonProperty("qyxzwqbz")
    private String downloadPreviousDataOption;

    /**
     * 批次号(一月多次发薪)
     */
    @JsonProperty("pch")
    private Integer batchNo;

    /**
     * 导入上月正常工资薪金(一月多次发薪)
     */
    @JsonProperty("sfdrsyzcgzxj")
    private String importLastMonthSalaryOption;

    /**
     * 是否需要人员申报
     * 0：人员不申报 1：人员申报
     */
    @JsonProperty("sfrysb")
    private String declareEmployeeOption;

    /**
     * 需要下载算税月份前几个月的往期
     */
    @JsonProperty("xzwqyfs")
    private Integer downloadPreviousDataMonths = 1;

    /**
     * 支持实时下载往期或者传入的往期进行计算
     */
    @JsonProperty("sfsycrwq")
    private String previousDataOption;

    /**
     * 年金算税上限选项
     */
    @JsonProperty("njzfgjjsxxx")
    private String annuityAndHouseProvidentFundOption;

    /**
     * 字段含义：多月算税，是否使用上月传入的应补退税额
     */
    @JsonProperty("sfsysyybtse")
    private String multiCalculateTaxUseRefundTax;

    /**
     * 个人养老金策略
     */
    @JsonProperty("gryljcl")
    private String personalPensionOption = PersonalPensionOptionEnum.DEFAULT.getCode();

    /**
     * 上月个人养老金策略
     */
    @JsonProperty("sygryljcl")
    private String lastMonthPersonalPensionOption = PersonalPensionOptionEnum.DEFAULT.getCode();

    /**
     * 离职日期处理策略
     */
    @JsonProperty("lzrqcl")
    private String resignDateStrategy;
}
