package cn.com.servyou.dto.tax.deduction;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author yujq
 * @since 20181212
 */
@Data
public abstract class AbstractSpecialDeduction implements Serializable {

    private static final long serialVersionUID = 6767412946067969241L;

    /**
     * 专项状态
     *
     * @Description 默认为正常，可选择正常/非正常，当需要作废时传非正常
     */
    @JsonProperty("zxzt")
    private String state = "正常";

    /**
     * 扣除年度
     */
    @JsonProperty("kcnd")
    private String deductedYear;

    /**
     * 扣除有效期起
     */
    @JsonProperty("kcyxqq")
    private String deductedStartDate;

    /**
     * 扣除有效期止
     */
    @JsonProperty("kcyxqz")
    private String deductedEndDate;

    /**
     * 采集来源
     */
    @JsonProperty("cjly")
    private String collectionSource;
}
