package cn.com.servyou.dto.tax.deduction;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * @author ranjh
 * @since 20211230
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class BabyCareSpecialDeduction extends AbstractSpecialDeduction {

    private static final long serialVersionUID = 1L;

    /**
     * 子女姓名
     */
    @JsonProperty("xm")
    private String babyName;

    /**
     * 子女证件类型名称
     */
    @JsonProperty("sfzjlx")
    private String babyLicenseTypeName;

    /**
     * 子女证件号码
     */
    @JsonProperty("sfzjhm")
    private String babyLicenseNumber;

    /**
     * 子女出生日期
     */
    @JsonProperty("csrq")
    private String babyBirthday;

    /**
     * 子女国籍
     *
     * @Description 见国籍字典
     */
    @JsonProperty("zngj")
    private String babyNationalityName;

    /**
     * 子女与员工的关系
     *
     * @Description 见字典表-家属关系字典
     */
    @JsonProperty("ynsrgx")
    private String relationshipTypeName;

    /**
     * 扣除比例
     *
     * @Description 可选择:50、100
     */
    @JsonProperty("fpbl")
    private BigDecimal distributionRatio;

    /**
     * 配偶备注
     */
    @JsonProperty("pobz")
    private String spouseRemark;

    /**
     * 备注
     */
    @JsonProperty("bz")
    private String remark;

    /**
     * 是否有配偶
     *
     * @Description 是/否
     */
    @JsonProperty("sfypo")
    private String hasSpouse;

    /**
     * 配偶姓名
     *
     * @Description 是否有配偶为是时必填
     */
    @JsonProperty("nsrpoxm")
    private String spouseName;

    /**
     * 配偶证件类型
     *
     * @Description 见证件类型字典，是否有配偶为是时必填
     */
    @JsonProperty("nsrposfzjlx")
    private String spouseLicenseType;

    /**
     * 配偶证件号码
     *
     * @Description 是否有配偶为是时必填
     */
    @JsonProperty("nsrposfzjhm")
    private String spouseLicenseNo;

    /**
     * 配偶出生日期
     */
    @JsonProperty("nsrpocsrq")
    private String spouseBirthday;

    /**
     * 配偶国籍
     *
     * @Description 是否有配偶为是时必填
     */
    @JsonProperty("nsrpogj")
    private String spouseNationality;

    /**
     * 配偶婚姻开始日期(yyyy-MM-dd)
     *
     * @Description 是否有配偶为是时必填
     */
    @JsonProperty("nsrpohykssj")
    private String spouseMarriageBeginDate;

    /**
     * 婚姻结束日期(yyyy-MM-dd)
     *
     * @Description 是否有配偶为是时必填
     */
    @JsonProperty("nsrpohyjssj")
    private String spouseMarriageEndDate;
}
