package cn.com.servyou.dto.tax.deduction;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * @author yujq
 * @since 20181129
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class ChildEducationAbstractSpecialDeduction extends AbstractSpecialDeduction {

    private static final long serialVersionUID = -7304601506277995721L;

    /**
     * 子女姓名
     */
    @JsonProperty("xm")

    private String childName;

    /**
     * 子女证件类型
     */
    @JsonProperty("sfzjlx")
    private String childLicenseType;

    /**
     * 子女证件号码
     */
    @JsonProperty("sfzjhm")
    private String childLicenseNo;

    /**
     * 子女出生日期
     */
    @JsonProperty("csrq")
    private String childBirthday;

    /**
     * 子女国籍
     *
     * @Description 见国籍字典
     */
    @JsonProperty("gjhdqsz")
    private String childNationality;

    /**
     * 子女与员工的关系
     */
    @JsonProperty("ynsrgx")
    private String childRelationship;

    /**
     * 是否有配偶
     *
     * @Description 是/否
     */
    @JsonProperty("sfypo")
    private String hasSpouse;

    /**
     * 配偶姓名
     *
     * @Description 是否有配偶为是时必填
     */
    @JsonProperty("nsrpoxm")
    private String spouseName;

    /**
     * 配偶证件类型
     *
     * @Description 见证件类型字典，是否有配偶为是时必填
     */
    @JsonProperty("nsrposfzjlx")
    private String spouseLicenseType;

    /**
     * 配偶证件号码
     *
     * @Description 是否有配偶为是时必填
     */
    @JsonProperty("nsrposfzjhm")
    private String spouseLicenseNo;

    /**
     * 配偶出生日期
     */
    @JsonProperty("nsrpocsrq")
    private String spouseBirthday;

    /**
     * 配偶国籍
     *
     * @Description 是否有配偶为是时必填
     */
    @JsonProperty("nsrpogj")
    private String spouseNationality;

    /**
     * 配偶婚姻开始日期(yyyy-MM-dd)
     *
     * @Description 是否有配偶为是时必填
     */
    @JsonProperty("nsrpohykssj")
    private String spouseMarriageBeginDate;

    /**
     * 婚姻结束日期(yyyy-MM-dd)
     *
     * @Description 是否有配偶为是时必填
     */
    @JsonProperty("nsrpohyjssj")
    private String spouseMarriageEndDate;

    /**
     * 当前受教育阶段
     *
     * @Description 学前教育阶段
     * 义务教育
     * 高中阶段教育
     * 大学专科
     * 大学本科
     * 硕士研究生
     * 博士研究生
     */
    @JsonProperty("sjyjd")
    private String educationStage;

    /**
     * 受教育期间起
     *
     * @Description YYYY-MM，必录，精确到月；受教育日期起不能大于当前日期
     */
    @JsonProperty("sjyrqq")
    private String educationStartDate;

    /**
     * 预计受教育时间止
     *
     * @Description YYYY-MM，受教育不能小于受教育日期起；【受教育时间止】或【教育终止时间】需要大于或等于政策生效日期起所在月份，精确到月
     */
    @JsonProperty("yjbysj")
    private String educationEndDate;

    /**
     * 教育终止时间
     *
     * @Description YYYY-MM，非必录，教育终止时间要大于受教育时间起，小于等于预计授权教育时间止，【受教育时间止】或【教育终止时间】需要大于或等于政策生效日期起所在月份
     */
    @JsonProperty("zjsjysj")
    private String educationDeadline;

    /**
     * 就读国家（地区）
     */
    @JsonProperty("jdgjhdqsz")
    private String educationNationality;

    /**
     * 就读学校名称
     */
    @JsonProperty("jdxx")
    private String educationSchool;

    /**
     * 分配比例
     */
    @JsonProperty("fpbl")
    private BigDecimal distributionRatio;

    /**
     * 配偶备注
     */
    @JsonProperty("pobz")
    private String spouseRemark;

    /**
     * 备注
     */
    @JsonProperty("bz")
    private String remark;
}
