package cn.com.servyou.dto.tax.deduction;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author zhouww
 * @version $Id: ChildEducationSpecialDeduction.java v 0.1 2018/11/29 下午10:11 YuJiaqi Exp $$
 */
@Data
public class ChildEducationSpecialDeduction extends SpecialDeduction {

    private static final long serialVersionUID = -7304601506277995721L;

    /**
     * 子女姓名
     */
    @JsonProperty("xm")
    private String childName;

    /**
     * 子女证照类型
     */
    @JsonProperty("sfzjlx")
    private String childLicenseType;

    /**
     * 子女证照号码
     */
    @JsonProperty("sfzjhm")
    private String childLicenseNo;

    /**
     * 子女出生日期
     */
    @JsonProperty("csrq")
    private String childBirthday;

    /**
     * 子女国籍
     */
    @JsonProperty("gjhdqsz")
    private String childNationality;

    /**
     * 子女与员工的关系
     */
    @JsonProperty("ynsrgx")
    private String childRelationship;

    /**
     * 是否有配偶
     */
    @JsonProperty("sfypo")
    private String hasSpouse;

    /**
     * 配偶姓名
     */
    @JsonProperty("nsrpoxm")
    private String spouseName;

    /**
     * 配偶证照类型
     */
    @JsonProperty("nsrposfzjlx")
    private String spouseLicenseType;

    /**
     * 配偶证照号码
     */
    @JsonProperty("nsrposfzjhm")
    private String spouseLicenseNo;

    /**
     * 配偶出生日期
     */
    @JsonProperty("nsrpocsrq")
    private String spouseBirthday;

    /**
     * 配偶国籍
     */
    @JsonProperty("nsrpogj")
    private String spouseNationality;

    /**
     * 配偶婚姻开始日期(yyyy-MM-dd)
     *
     * @Description 是否有配偶为是时必填
     */
    @JsonProperty("nsrpohykssj")
    private String spouseMarriageBeginDate;

    /**
     * 婚姻结束日期(yyyy-MM-dd)
     *
     * @Description 是否有配偶为是时必填
     */
    @JsonProperty("nsrpohyjssj")
    private String spouseMarriageEndDate;

    /**
     * 当前受教育阶段
     */
    @JsonProperty("sjyjd")
    private String educationStage;

    /**
     * 受教育期间起
     */
    @JsonProperty("sjyrqq")
    private String educationStartDate;

    /**
     * 预计受教育时间止
     */
    @JsonProperty("yjbysj")
    private String educationEndDate;

    /**
     * 教育终止时间
     */
    @JsonProperty("zjsjysj")
    private String educationDeadline;

    /**
     * 就读国家（地区）
     */
    @JsonProperty("jdgjhdqsz")
    private String educationNationality;

    /**
     * 就读学校名称
     */
    @JsonProperty("jdxx")
    private String educationSchool;

    /**
     * 分配比例
     */
    @JsonProperty("fpbl")
    private BigDecimal distributionRatio;
}
