package cn.com.servyou.dto.tax.deduction;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author yujq
 * @since 20181130
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class ContinueEducationAbstractSpecialDeduction extends AbstractSpecialDeduction {

    private static final long serialVersionUID = 2464173691173494752L;

    /**
     * 学历继续教育情况
     *
     * @Description 学历（学位）继续教育; 职业资格继续教育;
     */
    @JsonProperty("jxjyqk")
    private String continuingEducationSituation;

    /**
     * 入学时间
     *
     * @Description YYYY-MM，入学时间<（预计）毕业时间
     */
    @JsonProperty("rxsj")
    private String enrolmentDate;

    /**
     * 毕业时间
     *
     * @Description YYYY-MM，若“入学时间”不为空，则必录。（预计）毕业时间>=政策生效日期起所在月份
     */
    @JsonProperty("yjbysj")
    private String graduationDate;

    /**
     * 学历教育阶段
     */
    @JsonProperty("xljxjyjd")
    private String educationStage;

    /**
     * 非学历继续教育类型
     *
     * @Description 若“非学历继续教育情况”，则必填， 技能人员职业资格; 专业技术人员职业资格;
     */
    @JsonProperty("fxljxjylx")
    private String continuingEducationType;

    /**
     * 发证日期
     *
     * @Description YYYY-MM-DD，若“非学历继续教育情况”，继续教育类型有值，则必填
     */
    @JsonProperty("zsqdsj")
    private String obtainCertificateDate;

    /**
     * 证书名称
     */
    @JsonProperty("zsmc")
    private String certificateName;

    /**
     * 证件编号
     *
     * @Description 若“非学历继续教育情况”，继续教育类型有值，则必填
     */
    @JsonProperty("zsbh")
    private String certificateNumber;

    /**
     * 发证机关
     *
     * @Description 若“非学历继续教育情况”，继续教育类型有值，则必填
     */
    @JsonProperty("fzjg")
    private String certificateOffice;

}
