/**
 * cn.com.servyou.com.cn Inc.
 * Copyright (c) 1999-2019 All Rights Reserved.
 */

package cn.com.servyou.dto.tax.deduction;

import cn.com.servyou.dto.tax.BaseIncome;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.math.BigDecimal;

@Data
public class DeductibleDonation extends BaseIncome {

    /**
     * 所属期
     */
    @JsonProperty("ssq")
    private String period;

    /**
     * 所得类型代码
     */
    @JsonProperty("sdxmdm")
    private String incomeItemCode;

    /**
     * 受赠单位纳税人税号
     */
    @JsonProperty("szdwnsrsbh")
    private String acceptedTaxNo;

    /**
     * 受增单位名称
     */
    @JsonProperty("szdwmc")
    private String acceptedName;

    /**
     * 捐赠凭证号
     */
    @JsonProperty("jzpzh")
    private String donateVoucherNo;

    /**
     * 捐赠日期
     */
    @JsonProperty("jzrq")
    private String donateDate;

    /**
     * 捐赠金额
     */
    @JsonProperty("jzje")
    private BigDecimal donateAmount;

    /**
     * 实际扣除金额
     */
    @JsonProperty("sjkcje")
    private BigDecimal actualDeductionAmount;

    /**
     * 扣除比例
     */
    @JsonProperty("kcbl")
    private BigDecimal deductionProportion;

}
