package cn.com.servyou.dto.tax.deduction;

import cn.com.servyou.dto.tax.BaseEmployee;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.util.List;

/**
 * @author ranjh
 * @since 2024040524
 */
@Data
public class EmployeeSpecialDeduction extends BaseEmployee {

    /**
     * 子女教育专项扣除
     */
    @JsonProperty("znjys")
    private List<ChildEducationAbstractSpecialDeduction> childEducationList;

    /**
     * 赡养老人专项扣除
     */
    @JsonProperty("sylrs")
    private SupportElderAbstractSpecialDeduction supportElder;

    /**
     * 房屋租赁专项扣除
     */
    @JsonProperty("fwzls")
    private List<HouseRentAbstractSpecialDeduction> houseRentList;

    /**
     * 房屋贷款专项扣除
     */
    @JsonProperty("fwdks")
    private List<HouseLoanAbstractSpecialDeduction> houseLoanList;

    /**
     * 继续教育专项扣除
     */
    @JsonProperty("jxjys")
    private List<ContinueEducationAbstractSpecialDeduction> continueEducationList;

    /**
     * 大病医疗支出专项扣除
     */
    @JsonProperty("dbyls")
    private List<SeriousIllnessAbstractSpecialDeduction> seriousIllnessList;

    /**
     * 婴幼儿照护
     */
    @JsonProperty("yyezhls")
    private List<BabyCareSpecialDeduction> babyCareSpecialDeductionList;
}
