package cn.com.servyou.dto.tax.deduction;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author zhouww
 * @version $Id: HouseLoan.java v 0.1 2018/12/5 下午2:32 YuJiaqi Exp $$
 */
@Data
public class HouseLoan implements Serializable {

    /**
     * 贷款类型，公积金/商业银行
     */
    @JsonProperty("fdlx")
    private String loanType;

    /**
     * 贷款合同编号
     */
    @JsonProperty("zfdkhtbh")
    private String loanContractNo;

    /**
     * 贷款银行
     */
    @JsonProperty("dkyhmc")
    private String loanBank;

    /**
     * 首次还款日期
     */
    @JsonProperty("schkrq")
    private String firstRepaymentDate;

    /**
     * 贷款期限，月数
     */
    @JsonProperty("dkys")
    private Integer loanPeriod;

}
