package cn.com.servyou.dto.tax.deduction;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.util.List;

/**
 * @author zhouww
 * @version $Id: HouseLoanSpecialDeduction.java v 0.1 2018/11/30 下午3:10 YuJiaqi Exp $$
 */
@Data
public class HouseLoanSpecialDeduction extends SpecialDeduction {

    private static final long serialVersionUID = 3440515148860286347L;

    /**
     * 是否有配偶
     */
    @JsonProperty("sfypo")
    private String hasSpouse;

    /**
     * 配偶姓名
     */
    @JsonProperty("nsrpoxm")
    private String spouseName;

    /**
     * 配偶证照类型
     */
    @JsonProperty("nsrposfzjlx")
    private String spouseLicenseType;

    /**
     * 配偶证照号码
     */
    @JsonProperty("nsrposfzjhm")
    private String spouseLicenseNo;

    /**
     * 配偶出生日期
     */
    @JsonProperty("nsrpocsrq")
    private String spouseBirthday;

    /**
     * 配偶国籍
     */
    @JsonProperty("nsrpogj")
    private String spouseNationality;

    /**
     * 配偶婚姻开始日期(yyyy-MM-dd)
     *
     * @Description 是否有配偶为是时必填
     */
    @JsonProperty("nsrpohykssj")
    private String spouseMarriageBeginDate;

    /**
     * 婚姻结束日期(yyyy-MM-dd)
     *
     * @Description 是否有配偶为是时必填
     */
    @JsonProperty("nsrpohyjssj")
    private String spouseMarriageEndDate;

    /**
     * 房屋坐落地址
     */
    @JsonProperty("jzdxxdz")
    private String loanHouseAddress;

    /**
     * 房屋坐落地区省
     */
    @JsonProperty("fwszd_sheng")
    private String loanHouseProvince;

    /**
     * 房屋坐落地区市
     */
    @JsonProperty("fwszd_shi")
    private String loanHouseCity;

    /**
     * 房屋坐落地区县
     */
    @JsonProperty("fwszd_qx")
    private String loanHouseDistrict;

    /**
     * 房屋坐落地址街道
     */
    @JsonProperty("fwszd_jd")
    private String loanHouseStreet;

    /**
     * 房屋证书类型
     */
    @JsonProperty("fwzslx")
    private String houseLicenseType;

    /**
     * 房屋证书编号
     */
    @JsonProperty("zsh")
    private String houseLicenseNo;

    /**
     * 本人扣除比例是否为50%
     */
    @JsonProperty("sfgzkc")
    private String isFirstLoanBeforeMarry;

    /**
     * 是否夫妻双方婚前各自均有首套购房贷款
     */
    @JsonProperty("dkrsfbr")
    private String isSelfBorrower;

    /**
     * 房贷信息
     */
    @JsonProperty("fdxxs")
    private List<HouseLoan> houseLoanList;

}
