package cn.com.servyou.dto.tax.deduction;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author yujq
 * @since 20181130
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class HouseRentAbstractSpecialDeduction extends AbstractSpecialDeduction {

    private static final long serialVersionUID = 1815898559977758057L;

    /**
     * 是否有配偶
     */
    @JsonProperty("sfypo")
    private String hasSpouse;

    /**
     * 配偶姓名
     *
     * @Description 有配偶时必填
     */
    @JsonProperty("nsrpoxm")
    private String spouseName;

    /**
     * 配偶证件类型
     *
     * @Description 有配偶时必填
     */
    @JsonProperty("nsrposfzjlx")
    private String spouseLicenseType;

    /**
     * 配偶证件号码
     *
     * @Description 有配偶时必填
     */
    @JsonProperty("nsrposfzjhm")
    private String spouseLicenseNo;

    /**
     * 配偶出生日期
     *
     * @Description YYYY-MM-DD
     */
    @JsonProperty("nsrpocsrq")
    private String spouseBirthday;

    /**
     * 配偶国籍
     *
     * @Description 有配偶时必填
     */
    @JsonProperty("nsrpogj")
    private String spouseNationality;

    /**
     * 配偶婚姻开始日期(yyyy-MM-dd)
     *
     * @Description 是否有配偶为是时必填
     */
    @JsonProperty("nsrpohykssj")
    private String spouseMarriageBeginDate;

    /**
     * 婚姻结束日期(yyyy-MM-dd)
     *
     * @Description 是否有配偶为是时必填
     */
    @JsonProperty("nsrpohyjssj")
    private String spouseMarriageEndDate;

    /**
     * 主要工作地省
     */
    @JsonProperty("gzcsxzqh_sheng")
    private String majorWorkProvince;

    /**
     * 主要工作地市
     */
    @JsonProperty("gzcsxzqh_shi")
    private String majorWorkCity;

    /**
     * 出租方类型(个人、企业)
     *
     * @Description 个人 组织
     */
    @JsonProperty("czflx")
    private String rentType;

    /**
     * 出租方姓名
     *
     * @Description 若是个人填写个人姓名、若是组织填写组织名称
     */
    @JsonProperty("czrxm")
    private String rentName;

    /**
     * 出租方证件类型
     *
     * @Description 有出租方姓名时必填，“出租方类型”为“组织”时，“证件类型”不可输，见证件类型字典
     */
    @JsonProperty("czrsfzjlx")
    private String rentLicenseType;

    /**
     * 出租方证件号码(统一社会信用代码)
     *
     * @Description 有出租方姓名时必填，若是个人填写个人证件号码、若是组织填写统一社会信用代码
     */
    @JsonProperty("czrsfzjhm")
    private String rentLicenseNo;

    /**
     * 住房租赁合同编号
     */
    @JsonProperty("zfzlhtbh")
    private String rentContractNo;

    /**
     * 房屋坐落地区省
     */
    @JsonProperty("fwszd_sheng")
    private String rentHouseProvince;

    /**
     * 房屋坐落地区市
     */
    @JsonProperty("fwszd_shi")
    private String rentHouseCity;

    /**
     * 房屋坐落地区县
     */
    @JsonProperty("fwszd_qx")
    private String rentHouseDistrict;

    /**
     * 房屋坐落地址街道
     */
    @JsonProperty("fwszd_jd")
    private String loanHouseStreet;

    /**
     * 房屋坐落地址
     */
    @JsonProperty("jzdxxdz")
    private String rentHouseAddress;

    /**
     * 租赁日期起
     */
    @JsonProperty("zlrqq")
    private String rentStartDate;

    /**
     * 租赁日期止
     */
    @JsonProperty("zlrqz")
    private String rentEndDate;

    /**
     * 配偶备注
     */
    @JsonProperty("pobz")
    private String spouseRemark;
}
