package cn.com.servyou.dto.tax.deduction;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

/**
 * @author zhouww
 * @version $Id: HouseRentSpecialDeduction.java v 0.1 2018/11/30 下午3:00 YuJiaqi Exp $$
 */
@Data
public class HouseRentSpecialDeduction extends SpecialDeduction {

    private static final long serialVersionUID = 1815898559977758057L;

    /**
     * 是否有配偶
     */
    @JsonProperty("sfypo")
    private String hasSpouse;

    /**
     * 配偶姓名
     */
    @JsonProperty("nsrpoxm")
    private String spouseName;

    /**
     * 配偶证照类型
     */
    @JsonProperty("nsrposfzjlx")
    private String spouseLicenseType;

    /**
     * 配偶证照号码
     */
    @JsonProperty("nsrposfzjhm")
    private String spouseLicenseNo;

    /**
     * 配偶出生日期
     */
    @JsonProperty("nsrpocsrq")
    private String spouseBirthday;

    /**
     * 配偶国籍
     */
    @JsonProperty("nsrpogj")
    private String spouseNationality;

    /**
     * 配偶婚姻开始日期(yyyy-MM-dd)
     *
     * @Description 是否有配偶为是时必填
     */
    @JsonProperty("nsrpohykssj")
    private String spouseMarriageBeginDate;

    /**
     * 婚姻结束日期(yyyy-MM-dd)
     *
     * @Description 是否有配偶为是时必填
     */
    @JsonProperty("nsrpohyjssj")
    private String spouseMarriageEndDate;

    /**
     * 主要工作地城市
     */
    @JsonProperty("gzcsxzqh_sheng")
    private String majorWorkProvince;

    /**
     * 主要工作地省
     */
    @JsonProperty("gzcsxzqh_shi")
    private String majorWorkCity;

    /**
     * 出租方类型(个人、企业)
     */
    @JsonProperty("czflx")
    private String rentType;

    /**
     * 出租方姓名
     */
    @JsonProperty("czrxm")
    private String rentName;

    /**
     * 出租方证件类型
     */
    @JsonProperty("czrsfzjlx")
    private String rentLicenseType;

    /**
     * 出租方证照号码(统一社会信用代码)
     */
    @JsonProperty("czrsfzjhm")
    private String rentLicenseNo;

    /**
     * 住房租赁合同编号
     */
    @JsonProperty("zfzlhtbh")
    private String rentContractNo;

    /**
     * 房屋坐落地区省
     */
    @JsonProperty("fwszd_sheng")
    private String rentHouseProvince;

    /**
     * 房屋坐落地区市
     */
    @JsonProperty("fwszd_shi")
    private String rentHouseCity;

    /**
     * 房屋坐落地区县
     */
    @JsonProperty("fwszd_qx")
    private String rentHouseDistrict;

    /**
     * 房屋坐落地址街道
     */
    @JsonProperty("fwszd_jd")
    private String loanHouseStreet;

    /**
     * 房屋坐落地址
     */
    @JsonProperty("jzdxxdz")
    private String rentHouseAddress;

    /**
     * 租赁日期起
     */
    @JsonProperty("zlrqq")
    private String rentStartDate;

    /**
     * 租赁日期止
     */
    @JsonProperty("zlrqz")
    private String rentEndDate;

}
