package cn.com.servyou.dto.tax.deduction;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * @author yujq
 * @since 20181130
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class SeriousIllnessAbstractSpecialDeduction extends AbstractSpecialDeduction {

    private static final long serialVersionUID = 2719307052397035498L;

    /**
     * 患者姓名
     */
    @JsonProperty("xm")
    private String patientName;

    /**
     * 患者证件类型
     */
    @JsonProperty("sfzjlx")
    private String patientLicenseType;

    /**
     * 患者证件号码
     */
    @JsonProperty("sfzjhm")
    private String patientLicenseNo;

    /**
     * 患者出生日期
     */
    @JsonProperty("csrq")
    private String patientBirthday;

    /**
     * 患者国籍
     */
    @JsonProperty("gjhdqsz")
    private String patientNationality;

    /**
     * 患者与申报人关系
     */
    @JsonProperty("ynsrgx")
    private String patientRelationship;

    /**
     * 个人负担金额
     */
    @JsonProperty("zfcdzje")
    private BigDecimal selfPaymentAmount;

    /**
     * 医疗支出总金额
     */
    @JsonProperty("ylzczje")
    private BigDecimal medicalExpenditureAmount;

}
