package cn.com.servyou.dto.tax.deduction;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author zhouww
 * @version $Id: SeriousIllnessSpecialDeduction.java v 0.1 2018/11/30 下午4:06 YuJiaqi Exp $$
 */
@Data
public class SeriousIllnessSpecialDeduction extends SpecialDeduction {

    private static final long serialVersionUID = 2719307052397035498L;

    /**
     * 患者姓名
     */
    @JsonProperty("xm")
    private String patientName;

    /**
     * 患者证照类型
     */
    @JsonProperty("sfzjlx")
    private String patientLicenseType;

    /**
     * 患者证照号码
     */
    @JsonProperty("sfzjhm")
    private String patientLicenseNo;

    /**
     * 患者出生日期
     */
    @JsonProperty("csrq")
    private String patientBirthday;

    /**
     * 患者国籍
     */
    @JsonProperty("gjhdqsz")
    private String patientNationality;

    /**
     * 患者与申报人关系
     */
    @JsonProperty("ynsrgx")
    private String patientRelationship;

    /**
     * 个人负担金额
     */
    @JsonProperty("zfcdzje")
    private BigDecimal selfPaymentAmount;

    /**
     * 医疗支出总金额
     */
    @JsonProperty("ylzczje")
    private BigDecimal medicalExpenditureAmount;

}
