package cn.com.servyou.dto.tax.deduction;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author zhouww
 * @version $Id: SpecialDeduction.java v 0.1 2018/12/12 下午2:46 YuJiaqi Exp $$
 */
@Data
public abstract class SpecialDeduction implements Serializable {

    private static final long serialVersionUID = 6767412946067969241L;

    /**
     * 专项状态
     */
    @JsonProperty("zxzt")
    private String state = "正常";

    /**
     * 扣除年度
     */
    @JsonProperty("kcnd")
    private String deductedYear;

    /**
     * 扣除有效期起
     */
    @JsonProperty("kcyxqq")
    private String deductedStartDate;

    /**
     * 扣除有效期止
     */
    @JsonProperty("kcyxqz")
    private String deductedEndDate;

    /**
     * 采集来源
     */
    @JsonProperty("cjly")
    private String collectionSource;
}
