package cn.com.servyou.dto.tax.deduction;

import cn.com.servyou.dto.BaseRequest;
import cn.com.servyou.dto.employee.DeclareEmployeeOption;
import cn.com.servyou.dto.tax.CompanyEmployee;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.util.List;

/**
 * 询专项扣除信息VO
 *
 * @author ranjh
 * @since 20210729
 */
@Data
public class SpecialQueryRequest extends BaseRequest {

    /**
     * 企业员工列表
     */
    @JsonProperty("rylb")
    private List<CompanyEmployee> companyEmployeeList;

    /**
     * 专项下载模式
     * "1"-"下载最新专项" 全量下载
     * "2"-"下载变更专项" 增量下载
     */
    @JsonProperty("xzms")
    private String specialDownloadMode;

    /**
     * 是否需要人员申报
     * 0：人员不申报 1：人员申报
     */
    @JsonProperty("sfrysb")
    private String declareEmployeeOption = DeclareEmployeeOption.YES.getCode();
}
