package cn.com.servyou.dto.tax.deduction;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author ranjh
 * @since 20210729
 */
@Data
public class SpecialQueryResult implements Serializable {

    /**
     * 姓名
     */
    @JsonProperty("xm")
    protected String name;

    /**
     * 证件类型名称
     */
    @JsonProperty("zzlx")
    protected String licenseType;

    /**
     * 证件号码
     */
    @JsonProperty("zzhm")
    protected String licenseNumber;

    /**
     * 报送状态
     */
    @JsonProperty("sbzt")
    private String submissionState;

    /**
     * 失败原因
     */
    @JsonProperty("sbyy")
    private String message;

    /**
     * 累计子女教育支出
     */
    @JsonProperty("ljznjyzc")
    private BigDecimal accumulatedChildEducation;

    /**
     * 累计住房租金支出
     */
    @JsonProperty("ljzfzjzc")
    private BigDecimal accumulatedHouseRent;

    /**
     * 累计继续教育支出
     */
    @JsonProperty("ljjxjyzc")
    private BigDecimal accumulatedContinueEducation;

    /**
     * 累计房屋贷款支出
     */
    @JsonProperty("ljzfdklxzc")
    private BigDecimal accumulatedHouseLoan;

    /**
     * 累计赡养老人支出
     */
    @JsonProperty("ljsylrzc")
    private BigDecimal accumulatedSupportElder;

    /**
     * 累计学历继续教育支出
     */
    @JsonProperty("ljxljxjyzc")
    private BigDecimal accumulatedDegreeContinueEducationLimit;

    /**
     * 累计非学历继续教育支出
     */
    @JsonProperty("ljfxljxjyzc")
    private BigDecimal accumulatedUnDegreeContinueEducationLimit;

    /**
     * 子女教育支出
     */
    @JsonProperty("znjyzc")
    private BigDecimal childEducationExpenditure;

    /**
     * 累计婴幼儿照护支出
     */
    @JsonProperty("ljyyezhzc")
    private BigDecimal accumulatedBabyCare;

    /**
     * 婴幼儿照护支出
     */
    @JsonProperty("yyezhzc")
    private BigDecimal babyCareExpenditure;

    /**
     * 赡养老人支出
     */
    @JsonProperty("sylrzc")
    private BigDecimal supportElderExpenditure;

    /**
     * 房屋贷款支出
     */
    @JsonProperty("zfdklxzc")
    private BigDecimal houseLoanExpenditure;

    /**
     * 住房租金支出
     */
    @JsonProperty("zfzjzc")
    private BigDecimal houseRentExpenditure;

    /**
     * 继续教育支出
     */
    @JsonProperty("jxjyzc")
    private BigDecimal continueEducationExpenditure;

    /**
     * 非学历继续教育支出
     */
    @JsonProperty("fxljxjyzc")
    private BigDecimal unDegreeContinueEducationExpenditure;
}
