package cn.com.servyou.dto.tax.deduction;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author ranjh
 * @since 20230223
 */
@Data
public class StockholderEquityTransferDetailRequestVO {

    /**
     * 转让合同编号
     */
    @JsonProperty("zrhtbh")
    private String transferContractNumber;

    /**
     * 股权转让份额
     */
    @JsonProperty("gqzrfe")
    private BigDecimal transferShare;

    /**
     * 转让股权占企业总股份比例(%)，小数
     */
    @JsonProperty("zgbz")
    private BigDecimal transferProportion;

    /**
     * 股权转让合同（协议）价格
     */
    @JsonProperty("gqzrhtjg")
    private BigDecimal transferPrice;

    /**
     * 股权原值
     */
    @JsonProperty("gqyz")
    private BigDecimal originalValue;

    /**
     * 相关合理税费
     */
    @JsonProperty("hlsf")
    private BigDecimal rationalTaxAmount;

    /**
     * 是否分期递延纳税
     *
     * @Description 1-是，0-否
     */
    @JsonProperty("sffq")
    private String byStages;

    /**
     * 备案编号
     */
    @JsonProperty("babh")
    private String filingNumber;

    /**
     * 出让方备注
     */
    @JsonProperty("crfbz")
    private String transferorRemark;

    /**
     * 受让方类型名称
     *
     * @Description 组织 / 自然人
     */
    @JsonProperty("srflx")
    private String transfereeTypeName;

    /**
     * 受让方所在省份代码
     */
    @JsonProperty("srfszsf")
    private String transfereeProvinceName;

    /**
     * 受让方纳税人识别号/社会信用代码
     */
    @JsonProperty("srfnsrsbh")
    private String transfereeTaxNo;

    /**
     * 受让方纳税人姓名/企业名称
     */
    @JsonProperty("srfnsrxm")
    private String transfereeName;

    /**
     * 与股权出让方关系名称
     *
     * @Description 直系亲属 / 非直系亲属
     */
    @JsonProperty("ygqcrfgx")
    private String relationshipName;

    /**
     * 受让方备注
     */
    @JsonProperty("sfrbz")
    private String transfereeRemark;

    /**
     * 受让方登记序号
     */
    @JsonProperty("sfrdjxh")
    private String transfereeRegistrationNumber;
}
