package cn.com.servyou.dto.tax.deduction;

import cn.com.servyou.dto.tax.BaseIncome;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author ranjh
 * @since 20230223
 */
@Data
public class StockholderEquityTransferRequestVO extends BaseIncome {

    /**
     * 股权转让个人所得税申报类型
     *
     * @Description 纳税人申报、扣缴义务人申报、被投资企业申报
     */
    @JsonProperty("gqzrsblx")
    private String equityTransferTypeName;

    /**
     * 被投资企业所在省（市）代码
     */
    @JsonProperty("btzqyssdm")
    private String areaCode;

    /**
     * 被投资企业统一社会信用代码
     */
    @JsonProperty("btzqyshxydm")
    private String taxNo;

    /**
     * 被投资企业登记序号
     */
    @JsonProperty("btzqydjxh")
    private String registrationNumber;

    /**
     * 被投资企业名称
     */
    @JsonProperty("btzqymc")
    private String companyName;

    /**
     * 被投资企业注册资本（投资额）
     */
    @JsonProperty("tze")
    private BigDecimal registeredCapital;

    /**
     * 股权转让时间
     */
    @JsonProperty("gqzrsj")
    private String equityTransferDate;

    /**
     * 转让时企业账面净资产金额
     */
    @JsonProperty("qyzmjzc")
    private BigDecimal netAssets;

    /**
     * 其中实收资本
     */
    @JsonProperty("sszb")
    private BigDecimal paidInCapital;

    /**
     * 资本公积
     */
    @JsonProperty("zbgj")
    private BigDecimal capitalReserve;

    /**
     * 盈余公积
     */
    @JsonProperty("yygj")
    private BigDecimal surplusReserve;

    /**
     * 未分配利润
     */
    @JsonProperty("wfplr")
    private BigDecimal undistributedProfit;

    /**
     * 其他
     */
    @JsonProperty("qt")
    private BigDecimal other;

    /**
     * 拥有规定资产的企业转让时净资产公允价值
     */
    @JsonProperty("gyjz")
    private BigDecimal fairValue;

    /**
     * 个人股东股权转让信息明细列表
     */
    @JsonProperty("grgdgqzrxxmxlb")
    private List<StockholderEquityTransferDetailRequestVO> detailList;
}
