package cn.com.servyou.dto.tax.deduction;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.List;

/**
 * 赡养老人专项扣除
 *
 * @author yujq
 * @since 20181129
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class SupportElderAbstractSpecialDeduction extends AbstractSpecialDeduction {

    private static final long serialVersionUID = 5973204007875631096L;

    /**
     * 纳税人身份
     *
     * @Description (独生子女, 非独生子女)
     */
    @JsonProperty("nsrsf")
    private String taxpayerStatus;

    /**
     * 被赡养人
     */
    @JsonProperty("bsyrxxs")
    private List<Elder> elderList;

    /**
     * 分摊类型
     *
     * @Description 非独生子女必填，
     * 赡养人平均分摊
     * 赡养人约定分摊
     * 被赡养人指定分摊
     */
    @JsonProperty("ftfs")
    private String apportionType;

    /**
     * 分摊费用
     *
     * @Description 非必录；独生子女默认为每年36000元（每月3000元），非独生子女必填，但最高不得超过每年18000元（每月1500元）
     */
    @JsonProperty("ftje")
    private BigDecimal apportionFee;

    /**
     * 共同赡养人
     */
    @JsonProperty("gtsyrxxs")
    private List<NaturePerson> commonSupporterList;
}
