package cn.com.servyou.dto.tax.deduction;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * 赡养老人专项扣除
 *
 * @author zhouww
 * @version $Id: SupportElderSpecialDeduction.java v 0.1 2018/11/29 下午10:29 YuJiaqi Exp $$
 */
@Data
public class SupportElderSpecialDeduction extends SpecialDeduction {

    private static final long serialVersionUID = 5973204007875631096L;

    /**
     * 纳税人身份(独生子女,非独生子女)
     */
    @JsonProperty("nsrsf")
    private String taxpayerStatus;

    /**
     * 被赡养人
     */
    @JsonProperty("bsyrxxs")
    private List<Elder> elderList;

    /**
     * 分摊类型
     */
    @JsonProperty("ftfs")
    private String apportionType;

    /**
     * 分摊费用
     */
    @JsonProperty("ftje")
    private BigDecimal apportionFee;

    /**
     * 共同赡养人
     */
    @JsonProperty("gtsyrxxs")
    private List<NaturePerson> commonSupporterList;

}
