package cn.com.servyou.messagehandle;

import cn.com.servyou.utils.StringUtil;

/**
 * @author ranjh
 * @since 20221027
 */
public abstract class BaseMessageHandler {

    public BaseMessageHandler(SecretConfiguration configuration) {
        this.configuration = configuration;
    }

    SecretConfiguration configuration;

    public abstract String encrypt(String requestBody);

    public abstract String decrypt(String responseBody);

    public abstract void check();

    public void initConfiguration(SecretConfiguration configuration) {
        this.configuration = configuration;
    }

    public SecretConfiguration getConfiguration() {
        return configuration;
    }

    public void checkParam() {
        if (null == configuration) {
            throw new RuntimeException("秘要配置不能为空");
        }
        if (StringUtil.isBlank(configuration.getPublicKey())) {
            throw new RuntimeException("公钥不能为空");
        }
        if (configuration.isDecryptOutData() && StringUtil.isBlank(configuration.getPrivateKey())) {
            throw new RuntimeException("私钥不能为空");
        }
        check();
    }
}
