package cn.com.servyou.messagehandle;

import cn.com.servyou.messagehandle.sm.utils.Sm2Utils;

/**
 * @author ranjh
 * @since
 */
public class SMHandler extends BaseMessageHandler {

    public SMHandler(SecretConfiguration configuration) {
        super(configuration);
    }

    @Override
    public String encrypt(String requestBody) {
        return Sm2Utils.encrypt(requestBody, configuration.getPublicKey());
    }

    @Override
    public String decrypt(String responseBody) {
        return Sm2Utils.decrypt(responseBody, configuration.getPrivateKey());
    }

    @Override
    public void check() {
    }
}
